//## begin module%1.4%.codegen_version preserve=yes
//   Read the documentation to learn more about C++ code generator
//   versioning.
//## end module%1.4%.codegen_version

//## begin module%3D86D33A00C8.cm preserve=no
//	  %X% %Q% %Z% %W%
//## end module%3D86D33A00C8.cm

//## begin module%3D86D33A00C8.cp preserve=no
//## end module%3D86D33A00C8.cp

//## Module: UI%3D86D33A00C8; Pseudo Package body
//## Source file: C:\Program Files\Rational\Rose\C++\source\UI.cpp

//## begin module%3D86D33A00C8.additionalIncludes preserve=no
//## end module%3D86D33A00C8.additionalIncludes

//## begin module%3D86D33A00C8.includes preserve=yes
//## end module%3D86D33A00C8.includes

// UI
#include "UI.h"
//## begin module%3D86D33A00C8.additionalDeclarations preserve=yes
//## end module%3D86D33A00C8.additionalDeclarations


// Class UI

//## begin UI::READY%3D9AB2D2003C.attr preserve=no  private: static int {UC} 0
const int UI::READY = 0;
//## end UI::READY%3D9AB2D2003C.attr

//## begin UI::RUNNING%3D9AB2F201A4.attr preserve=no  private: static int {UC} 1
const int UI::RUNNING = 1;
//## end UI::RUNNING%3D9AB2F201A4.attr

UI::UI (char* name, int stackSize, int priority, int id)
  //## begin UI::UI%3D9EBE030096.hasinit preserve=no
      : state(-1)
  //## end UI::UI%3D9EBE030096.hasinit
  //## begin UI::UI%3D9EBE030096.initialization preserve=yes
  ,Thread(name,stackSize,priority,id)
  //## end UI::UI%3D9EBE030096.initialization
{
  //## begin UI::UI%3D9EBE030096.body preserve=yes
  //## end UI::UI%3D9EBE030096.body
}

void UI::initialize(void)
{
  mes[OSMachineID()] = this;
  starter.initialize();
}

//UI does not need destructor, kill() is done in destructor of Thread


// Additional Declarations
  //## begin UI%3D86D33A00C8.declarations preserve=yes
void UI::run(void)
{
  //lcd.clear (crashes) and keyboard.getKey (halts the program or the console) do not work in EyeSim
  //lcd.putString("Press any key..\n");
  //keyboard.getKey();
  //lcd.clear();

  //             0123456789012345
  lcd.putString(" Collaborative \n");
  lcd.putString("Cube Clustering\n");
  lcd.putString("               \n");
  lcd.putString("   Jia L. Du   \n");
  lcd.putString("Prof. T. Braunl\n");
  lcd.putString("               \n");
  lcd.putString("      UWA      ");

  lcd.setMenu("Go", " ", " ", "End");
  state = READY;
  while(1)
  {
    int key = keyboard.readKey();
    if (key == keyboard.KEY_1) //'Go' pressed
    {
      if (state == READY)
      {
        starter.startClustering();
        lcd.setMenu(" ", " ", " ", "End");
        state = RUNNING;
      }
    }
    else if (key == keyboard.KEY_4) //'End' pressed
    {
      if (state == RUNNING)
      {
        starter.stopClustering();
      }
      lcd.setMenu(" ", " ", " ", " ");
      state = -1;
      suspend(); //suspends thread. As all other threads are suspended as well the control is returned to main
    }

    reschedule(); //nothing to do, so let other threads work
  }
}

  bool UI::spawn ()
  {
    threadControlBlock = OSSpawn(name, staticRun, stackSize, priority, OSMachineID()*10+id);
    if (threadControlBlock)
      return true;
    else
      return false;
  }

  void UI::staticRun ()
  {
    mes[OSMachineID()]->run();
  }

  UI* UI::mes[NUMBER_OF_ROBOTS];
  //## end UI%3D86D33A00C8.declarations

//## begin module%3D86D33A00C8.epilog preserve=yes
//## end module%3D86D33A00C8.epilog

