//## begin module%1.4%.codegen_version preserve=yes
//   Read the documentation to learn more about C++ code generator
//   versioning.
//## end module%1.4%.codegen_version

//## begin module%3D86D40302D0.cm preserve=no
//	  %X% %Q% %Z% %W%
//## end module%3D86D40302D0.cm

//## begin module%3D86D40302D0.cp preserve=no
//## end module%3D86D40302D0.cp

//## Module: PSDs%3D86D40302D0; Pseudo Package body
//## Source file: C:\Program Files\Rational\Rose\C++\source\PSDs.cpp

//## begin module%3D86D40302D0.additionalIncludes preserve=no
//## end module%3D86D40302D0.additionalIncludes

//## begin module%3D86D40302D0.includes preserve=yes
#include "Version.h"
//## end module%3D86D40302D0.includes

// PSDs
#include "PSDs.h"
//## begin module%3D86D40302D0.additionalDeclarations preserve=yes
//## end module%3D86D40302D0.additionalDeclarations


// Class PSDs 

//## begin PSDs::aPSD%3D9AA1E00366.attr preserve=no  private: static PSDs {U}
PSDs PSDs::psds[NUMBER_OF_ROBOTS];
//## end PSDs::aPSD%3D9AA1E00366.attr

PSDs::PSDs()
  //## begin PSDs::PSDs%3D86D40302D0_const.hasinit preserve=no
  //## end PSDs::PSDs%3D86D40302D0_const.hasinit
  //## begin PSDs::PSDs%3D86D40302D0_const.initialization preserve=yes
  //## end PSDs::PSDs%3D86D40302D0_const.initialization
{
  //## begin PSDs::PSDs%3D86D40302D0_const.body preserve=yes
  //to run the program on the EyeSim simulator the initialization must not take place
  //in the constructor
  //so we have to declare the method as public and call it in main before we start
  //the program
  //if running the program on real robots the initialization must be done in the
  //constructors (otherwise the camera initialization doesn't work, for example
  //(for whatever reason)
//  initialize();
  //## end PSDs::PSDs%3D86D40302D0_const.body
}


PSDs::~PSDs()
{
  //## begin PSDs::~PSDs%3D86D40302D0_dest.body preserve=yes
	release();
  //## end PSDs::~PSDs%3D86D40302D0_dest.body
}



//## Other Operations (implementation)
PSDs* PSDs::getPSDs ()
{
  //## begin PSDs::getPSDs%3D9AA1F70078.body preserve=yes
  return &psds[OSMachineID()];
  //## end PSDs::getPSDs%3D9AA1F70078.body
}

double PSDs::readLeft ()
{
  //## begin PSDs::readLeft%3D9029830334.body preserve=yes
#ifdef EYEBOT8_CUBECLUSTERING_PARAMETERS
  return double(PSDGet(leftPSDHandle))/1000.0 * 1.88; //should not be done here???
#endif
#ifdef EYEBOT3_CUBECLUSTERING_PARAMETERS
  return (double(PSDGet(leftPSDHandle))/1000.0 * 1.76); //should not be done here???
#endif
#ifdef EYESIM_CUBECLUSTERING_PARAMETERS
  return (double(PSDGet(leftPSDHandle))/1000.0 * 1.76); //should not be done here???
#endif
  //## end PSDs::readLeft%3D9029830334.body
}

double PSDs::readRight ()
{
  //## begin PSDs::readRight%3D9029B1023A.body preserve=yes
#ifdef EYEBOT8_CUBECLUSTERING_PARAMETERS
  return double(PSDGet(rightPSDHandle))/1000.0 * 1.88; //should not be done here???
#endif
#ifdef EYEBOT3_CUBECLUSTERING_PARAMETERS
  return (double(PSDGet(rightPSDHandle)-20)/1000.0 * 1.88); //should not be done here???
#endif
#ifdef EYESIM_CUBECLUSTERING_PARAMETERS
  return (double(PSDGet(rightPSDHandle)-20)/1000.0 * 1.88); //should not be done here???
#endif
  //## end PSDs::readRight%3D9029B1023A.body
}

double PSDs::readFront ()
{
  //## begin PSDs::readFront%3D9029B603B6.body preserve=yes
  return double(PSDGet(frontPSDHandle))/1000.0;
  //## end PSDs::readFront%3D9029B603B6.body
}

bool PSDs::initialize ()
{
  //## begin PSDs::initialize%3D902A18000A.body preserve=yes

  leftPSDHandle = PSDInit(PSD_LEFT);
  rightPSDHandle = PSDInit(PSD_RIGHT);
  frontPSDHandle = PSDInit(PSD_FRONT);


  if (PSDStart(leftPSDHandle|rightPSDHandle|frontPSDHandle, true) != 0) //true: continuous measuring instead of a single measurement
  {
		LCDPutString("PSDs init. error!\n");
		OSPanic(""); //put that into calling function and return false here??
  }


  return true;

  //## end PSDs::initialize%3D902A18000A.body
}

bool PSDs::release ()
{
  //## begin PSDs::release%3D902A210122.body preserve=yes
  PSDRelease();
  return true;
  //## end PSDs::release%3D902A210122.body
}

// Additional Declarations
  //## begin PSDs%3D86D40302D0.declarations preserve=yes
  //## end PSDs%3D86D40302D0.declarations

//## begin module%3D86D40302D0.epilog preserve=yes
//## end module%3D86D40302D0.epilog
