/* ********************************** */
/* gray-detect.c                      */
/* Simple Grayscale Detection Program */
/* Thomas Braunl, UWA, 2004           */
/* ********************************** */
#include "eyebot.h"
#define MIN(a,b) (a<b?a:b)
#define MAX(a,b) (a>b?a:b)

int main()
{ image g;
  int i,j, disp, maxdisp, maxindex;

  LCDPrintf("Find Max. Disp.\n");
  LCDMenu("","","","EXIT");
  CAMInit(NORMAL);
  while ((KEYRead() != KEY4))
  { CAMGetFrame(&g);
    LCDPutGraphic(&g);

    for (j=1; j<imagecolumns-1; j++)
    { /* find and mark highest disparity in every column */
      maxdisp=0; maxindex=1;
      for (i=1; i<imagerows-2; i++)
      { disp = abs(g[i][j] - g[i+1][j]);
        if (disp>maxdisp) { maxdisp=disp; maxindex=i; }
      }
      LCDLine(j, maxindex-1,j, maxindex+1, 2); /* invert */
    }
  }
  return 0;
}
