#ifndef TREE_H
#define TREE_H
#include "constgp.h"

struct t_node {
        Sym_Type sym_t;
	int symbol;
        struct t_node **children;
	struct t_node *parent;
	int n_children;
	int capacity;
	int n_active_children;
	};

typedef struct t_node *Node;

/* This structure is rather obsolete, since depth is not used. Maybe remove it later. Only using it now because if
I use initNode, I have to put in more information (like symbol_type, etc.)  */
struct parse_tree {
        int depth;      // Indicates the number of LIST statements in the tree. But its redundant now
        Node root;
        };

typedef struct parse_tree *Tree;


Node initNode(Sym_Type type, int sym, int n_children);

Tree initTree(void);

void add2Tree(Tree t, int symbol);

void printTree(Tree t, char *string);

void CompareTree (Node n1, Node n2, int *compare);

void Compare (Node n1, Node n2, int *compare);

void printOptimalTree(Tree t, char *string, double fitness);

void CalculateDepth (Node n, int *max_depth);

void MovetoList (Node n, int listno, int *cur_position, Tree t);

void ReplaceTree (Node n1, Node n2, int listno, int switch_point, int *cur_position);

void DeleteNode (Node n);

void CopyNode (Node *n1, Node n2);

void PrintNode (Node n1);

#endif

