#include <eyebot.h>
#include "constgp.h"

/**
 * @brief Used to pass Red, Green, Blue and Hue values between functions.
 *
 * Used in: defBallColour, searchBall2d, frontBallCol, frontSearch, main.
 */
typedef struct rgbhue
{
  int red;    /**< holds red value from 0-255. */
  int green;  /**< holds green value from 0-255. */
  int blue;   /**< holds blue value from 0-255. */
  int hue;    /**< holds hue value from 0-255. */
} rgbhue;


/** Maintains the last FRAMESIZEAVE sizes */
typedef struct sizelib
{
  int oldest;
  int sizearray[FRAMESIZEAVE];
  int filled;
}lastsizes;


int findObj(float *distance, colimage *img, rgbhue *pixsearch, lastsizes *dis);

/** @brief Change RBG to HSV -- use hue only.
    
    Called by defBallColour, searchBall2d, frontSearch.
    @author Thomas Braunl, UWA 1998.
    @see searchBall2d()
    @param r,g,b rgb value of single pixel
    @return hue for single RGB value 
*/
int RGBtoHue(BYTE r, BYTE g, BYTE b);


/**
 * @brief Searches an image for the location of a ball.
 *
 * @param x column where ball's center is located (used for output)
 * @param y row where ball's center is located (used for output)
 * @param xthres number of hue matches that constitute a ball being found in the x
 * @param ythres number of hue matches that constitute a ball being found in the y
 * @param image input colour image
 * @param pixbuff rgbhue struct containing values to search for
 * @param xsize width of ball (used for output)
 * @param ysize height of ball (used for output)
 * @param hue hue of ball on image
 * @param huerange range of hues to search for
 * @param stepsize check every "stepsize" pixel
 * @param xhist histogram of hue density in x (used for output)
 * @param yhist histogram of hue density in y (used for output)
 * @return FOUND or NOTFOUND
 */

int searchBall2d(int *x, int *y, int xthres, int ythres, int *xsize, int *ysize, colimage image, rgbhue pixbuff, int huerange, int stepsize, int *xhist, int *yhist);


/**
 * @brief Creates an all white (clear) image.
 * @return An all white image.
 */
void imgWhite(image clearer);

void initSizelib(lastsizes *x);

/**
 * @brief Inserts a size into sizelib.
 */
void insertSizelib(lastsizes *x, int size);


void dispHist(int *xhist, int *yhist, int xsize, int ysize, int ballfound, int pix_size, int x, int y);

float scanDist(lastsizes *x);

void ColSearch2 (colimage img, int obj_hue, int thres, int *pos, int *val);

