#ifndef _HDT_SEM
#define _HDT_SEM

/*********************************************************************/
/*  semantic-constants, give the semantic of an HDT entry                */
/*********************************************************************/

#define     MOTOR_RIGHT          -100
#define     MOTOR_LEFT           -101
#define     MOTOR_FR           MOTOR_RIGHT
#define     MOTOR_FL           MOTOR_LEFT
#define     MOTOR_BR             -102
#define     MOTOR_BL             -103
#define     MOTOR_STEER          -110
#define     MOTOR_DRIVE          -111
#define     MOTOR_TURN           -112
#define     LEFTMOTOR          MOTOR_LEFT
#define     RIGHTMOTOR         MOTOR_RIGHT


#define     PSD_FRONT            -200
#define     PSD_FRONTLEFT        -201
#define     PSD_FRONTRIGHT       -202
#define     PSD_LEFTDIAG         -203
#define     PSD_RIGHTDIAG        -204
#define     PSD_LEFT             -205
#define     PSD_RIGHT            -210
#define     PSD_FRONT2           -211
#define     PSD_BACK             -212
#define     PSD_TEST             -215

#define     SERVO0          -350
#define     SERVO1          -351
#define     SERVO2          -352
#define     SERVO3          -353
#define     SERVO4          -354
#define     SERVO5          -355
#define     SERVO6          -356
#define     SERVO7          -357
#define     SERVO8          -358
#define     SERVO9          -359
#define     SERVO10         -360
#define     SERVO11         -361
#define     SERVO12         -362
#define     SERVO13         -363
#define     SERVO14         -364
#define     SERVO15         -365

#define     SER_LFUD        SERVO0       /* Left Front Up Down */             
#define     SER_LFFB        SERVO1       /* Left Front Forward Backward */    
#define     SER_RFUD        SERVO2       
#define     SER_RFFB        SERVO3      
#define     SER_LMUD        SERVO4     
#define     SER_LMFB        SERVO5    
#define     SER_RMUD        SERVO6   
#define     SER_RMFB        SERVO7  
#define     SER_LRUD        SERVO8 
#define     SER_LRFB        SERVO9   
#define     SER_RRUD        SERVO10 
#define     SER_RRFB        SERVO11

#define     RHipT           SERVO0
#define     RHipB           SERVO1
#define     RKnee           SERVO2          
#define     RAnkle          SERVO3          
#define     Torso           SERVO4          
#define     RArm            SERVO7
#define     LArm            SERVO8
#define     LAnkle          SERVO11          
#define     LKnee           SERVO12          
#define     LHipB           SERVO13          
#define     LHipT           SERVO14          

#define     L_HipSide       SERVO1
#define     L_HipBend       SERVO2
#define     L_Knee          SERVO3
#define     L_AnkleBend     SERVO4
#define     L_AnkleSide     SERVO5
#define     L_Arm           SERVO6
#define     R_HipSide       SERVO7
#define     R_HipBend       SERVO8
#define     R_Knee          SERVO9
#define     R_AnkleBend     SERVO10
#define     R_AnkleSide     SERVO11
#define     R_Arm           SERVO12
#define     Head            SERVO13


#define     QUAD_LEFT            -400
#define     QUAD_RIGHT           -401
#define     QUAD_FL              QUAD_LEFT
#define     QUAD_FR              QUAD_RIGHT
#define     QUAD_BL              -402
#define     QUAD_BR              -403
#define     QUAD_DRIVE           -404
#define     QUAD_STEER           -405
#define     QUAD_TURN            -406


#define     BUMP_LEFT            -500
#define     BUMP_RIGHT           -501


#define     IR_LF                -600
#define     IR_LM                -601
#define     IR_LB                -602
#define     IR_RF                -603
#define     IR_RM                -604
#define     IR_RB                -605
#define     IR_BA                -606

#define     VW_DRIVE             -700

#define     BATTERY              -800

#define     COMPASS              -900

#define     IRTV                 -1000

#define     STARTIMAGE           -1100
#define     STARTMELODY          -1200

#define     REMOTE               -1300

#define     GYRO_FB              -1400
#define     GYRO_LR              -1401
#define     INCLINO_FB           -1402
#define     INCLINO_LR           -1403
#define     ACCEL_FB             -1404
#define     ACCEL_LR             -1405

#define     LATCH                -1500

#endif
