/*
| -----------------------------------------------------------------------------
| Filename: Blizhdt.c
|
| Author:       Courtney Smith
|		Nicholas Stamatiou
|               
| Description: 
| -------
| Updated for Front PSD
| HDT data for Blizzard EV using EyeBot MK4, UWA 2002
| -----------------------------------------------------------------------------
*/

#define VERSION 1.1      /* User specific version nr. for information */
#define NAME "Blizard"   /* controller name max. 7 chars, inform. only */
#define ID   3           /* Unique platform id (int), just for inform. */

#include "hdt.h"
#include "hdt_sem.h"

/* The HDT structure */
/*-------------------*/
int     magic = 123456789;
extern HDT_entry_type HDT[];
HDT_entry_type  *hdtbase = &HDT[0];

#include "types.h"
#include "const.h"
#include "rs232.h"
#include "cam.h"
#include "librobi/librobi.h"

/* infraread remote control on Servo S12 */
irtv_type irtv = {0, 13, TPU_HIGH_PRIO};

/* Blizzard Compass - Ivan rearranged pin to pin 10 --> DI5*/
 compass_type compass = {0,3,(void*)IOBase, 5,(void*)IOBase, 6, (BYTE*)IOBase, 5};

/* conventional compass - Using pin 9 --> DI4
compass_type compass = {0,6,(void*)IOBase, 5,(void*)IOBase, 6, (BYTE*)IOBase, 4}; */

short dist0[128] = { 60,  60,  60,  60,  60,  60,  60,  60,  60,  60,  60,  60,  60,  60,  60,
                     60,  60,  60,  60,  60,  60,  60,  60,  60,  60,  65,  69,  70,  73,  75,
                     76,  77,  79,  81,  84,  85,  87,  88,  89,  90,  93,  95,  96,  98, 100,
                    103, 105, 107, 109, 110, 112, 114, 116, 117, 119, 121, 126, 127, 129, 131,
                    134, 137, 140, 144, 146, 149, 151, 156, 159, 167, 170, 175, 179, 183, 188,
                    195, 200, 205, 210, 220, 225, 235, 240, 250, 265, 275, 285, 295, 310, 320,
                    340, 350, 370, 380, 400, 410, 440, 460, 490, 530, 600, 610, 630, 680, 750,
                    830, 900, 999, 999, 999, 999, 999, 999, 999, 999, 999, 999, 999, 999, 999,
                    999, 999, 999, 999, 999, 999, 999, 999};

short distF1[128] = { 46,  46,  46,  46,  46,  47,  48,  49,  50,  53,  57,  59,  61,  62,  63,
                      64,  65,  65,  66,  68,  70,  71,  72,  74,  75,  76,  77,  78,  79,  82,
                      85,  86,  87,  88,  89,  92,  94,  94,  95,  97, 100, 103, 105, 107, 108,
                     113, 118, 118, 119, 121, 124, 127, 130, 133, 137, 142, 147, 150, 152, 156,
                     161, 166, 170, 176, 182, 188, 191, 198, 205, 212, 221, 229, 234, 242, 251,
                     262, 273, 287, 301, 314, 327, 341, 354, 372, 392, 416, 439, 467, 496, 526,
                     556, 590, 625, 660, 694, 736, 777, 827, 875, 999, 999, 999, 999, 999, 999,
                     999, 999, 999, 999, 999, 999, 999, 999, 999, 999, 999, 999, 999, 999, 999,
                     999, 999, 999, 999, 999, 999, 999, 999};

short distF2[128] = { 80,  80,  80,  80,  80,  80,  80,  80,  80,  80,  80,  80,  87,  92,  94,
                      97,  99, 100, 103, 105, 106, 108, 109, 110, 112, 114, 116, 118, 120, 121,
                     123, 125, 128, 130, 132, 134, 136, 139, 142, 145, 148, 151, 153, 156, 160,
                     164, 170, 176, 180, 185, 190, 196, 202, 208, 213, 219, 224, 229, 235, 241,
                     252, 257, 263, 269, 276, 284, 294, 304, 320, 335, 352, 368, 389, 410, 435,
                     462, 490, 519, 570, 617, 695, 767, 999, 999, 999, 999, 999, 999, 999, 999,
                     999, 999, 999, 999, 999, 999, 999, 999, 999, 999, 999, 999, 999, 999, 999,
                     999, 999, 999, 999, 999, 999, 999, 999, 999, 999, 999, 999, 999, 999, 999,
                     999, 999, 999, 999, 999, 999, 999, 999};

short distL[128] = {  50,  50,  50,  50,  50,  50,  50,  50,  50,  50,  50,  50,  50,  50,  50,
                      50,  50,  50,  50,  50,  50,  50,  50,  50,  50,  52,  54,  56,  58,  61,
                      63,  65,  67,  69,  70,  73,  74,  76,  80,  82,  86,  90,  94,  98, 101,
                     104, 108, 112, 116, 120, 124, 129, 134, 138, 145, 152, 160, 169, 177, 185,
                     192, 200, 211, 222, 234, 246, 256, 269, 284, 305, 323, 343, 355, 367, 411,
                     460, 510, 555, 675, 707, 999, 999, 999, 999, 999, 999, 999, 999, 999, 999,
                     999, 999, 999, 999, 999, 999, 999, 999, 999, 999, 999, 999, 999, 999, 999,
                     999, 999, 999, 999, 999, 999, 999, 999, 999, 999, 999, 999, 999, 999, 999,
                     999, 999, 999, 999, 999, 999, 999, 999};

short distR[128] = {  50,  50,  50,  50,  50,  50,  50,  50,  50,  50,  50,  50,  50,  50,  50,
                      50,  50,  50,  50,  50,  50,  50,  50,  50,  50,  50,  50,  50,  50,  50,
                      50,  50,  50,  50,  50,  50,  50,  50,  50,  50,  52,  54,  55,  57,  59,
                      61,  64,  67,  68,  70,  72,  74,  77,  81,  84,  87,  90,  93,  95,  98,
                     103, 107, 111, 115, 119, 123, 128, 134, 139, 144, 150, 157, 163, 169, 177,
                     185, 192, 201, 210, 221, 232, 243, 257, 269, 284, 303, 320, 341, 365, 390,
                     420, 452, 492, 530, 570, 645, 715, 790, 999, 999, 999, 999, 999, 999, 999,
                     999, 999, 999, 999, 999, 999, 999, 999, 999, 999, 999, 999, 999, 999, 999,
                     999, 999, 999, 999, 999, 999, 999, 999};

short distB1[128] = { 60,  60,  60,  60,  60,  61,  63,  66,  69,  70,  71,  72,  73,  74,  75,
                      76,  77,  79,  81,  82,  83,  85,  85,  86,  88,  90,  92,  94,  94,  95,
                      97,  99, 100, 102, 104, 106, 108, 110, 110, 111, 114, 116, 118, 120, 122,
                     124, 127, 129, 131, 133, 136, 139, 142, 144, 147, 150, 152, 154, 158, 161,
                     166, 171, 177, 182, 186, 190, 193, 195, 201, 207, 213, 220, 225, 231, 236,
                     242, 252, 261, 270, 280, 291, 303, 318, 330, 345, 362, 381, 400, 424, 448,
                     472, 500, 536, 573, 623, 675, 735, 811, 999, 999, 999, 999, 999, 999, 999,
                     999, 999, 999, 999, 999, 999, 999, 999, 999, 999, 999, 999, 999, 999, 999,
                     999, 999, 999, 999, 999, 999, 999, 999};


/* SERVOs */
/* type, TPU-channel, Timer2, 20ms period, 0.7ms min, 1.7ms max */
/* here: servo 1 has TPU channel 2, and so on                   */
servo_type servo0 = {2, 8, TIMER1, 20000, 0, 2000}; 		/* Throttle */
servo_type servo1 = {2, 9, TIMER2, 20000, 1000, 2000}; 		/* Steering */
servo_type servo2 = {2, 10, TIMER2, 20000, 1400, 1800}; 	/* Camera Y */
servo_type servo3 = {2, 11, TIMER2, 20000, 900, 2100}; 		/* Camera Z */
servo_type servo4 = {2, 12, TIMER2, 20000, 900, 2300}; 	    /* Camera Tilt */
servo_type servo5 = {2, 4, TIMER2, 20000, 0, 19000}; 	    /* Gyro Forward*/
servo_type servo6 = {2, 5, TIMER2, 20000, 0, 19000}; 	    /* Gyro Tilt*/


/* PSD-infrared */
psd_type   psd0   = {0, 14, (BYTE*)IOBase, 0, AH, (BYTE*)IOBase, 0, AH,(short*)&distF1};
psd_type   psd1   = {0, 14, (BYTE*)IOBase, 1, AH, (BYTE*)IOBase, 0, AH,(short*)&distL};
psd_type   psd2   = {0, 14, (BYTE*)IOBase, 2, AH, (BYTE*)IOBase, 0, AH,(short*)&distR};
psd_type   psd3   = {0, 14, (BYTE*)IOBase, 3, AH, (BYTE*)IOBase, 0, AH,(short*)&dist0};
psd_type   psd4   = {0, 14, (BYTE*)sim_porte, 5, AH, (BYTE*)IOBase, 0, AH,(short*)&distB1};
psd_type   psd5   = {0, 14, (BYTE*)sim_porte, 4, AH, (BYTE*)IOBase, 0, AH,(short*)&distF2};
/*PSD copied from socbot34.c */

/* EyeBot SUMMARY */
info_type roboinfo  = {0,VEHICLE,SER115200,RTSCTS,SERIAL1,0,0,AUTOBRIGHTNESS,BATTERY_ON,35,VERSION,NAME,ID};

/* waitstates = 0..13, Fast Termination = 14, External = 15 */
/* Version, ROM, RAM, LCD, IO, Parallel+Serial2/3 */
/* 16MHz - 20Mhz */
/* waitstate_type waitstates = {0,3,0,1,0,2}; */
/* 21MHz - 41Mhz */
waitstate_type waitstates = {0,3,1,2,1,2};

/* this is a test HDT structure which contains ALL EyeBot hardware devices */

HDT_entry_type HDT[] =
{
    {SERVO,SERVO7,"Throt",(void *)&servo0},
    {SERVO,SERVO8,"Steer",(void *)&servo1},
    {SERVO,SERVO9,"Cam-Y",(void *)&servo2},
    {SERVO,SERVO10,"Cam-Z",(void *)&servo3},
    {SERVO,SERVO11,"Cam-T",(void *)&servo4},
    {SERVO,SERVO3,"Gyro" , (void *)&servo5},
    {SERVO,SERVO4,"Gyro2" ,(void *)&servo6},

    {PSD,PSD_FRONT,   	"Front0", (void *)&psd0},  /*Front Camera*/
    {PSD,PSD_LEFT,    	"Left 1", (void *)&psd1},  /*Left  */
    {PSD,PSD_RIGHT,   	"Right2", (void *)&psd2},  /*Right */
    {PSD,PSD_TEST,    	"BackD3", (void *)&psd3},  /*Diag */
    {PSD,PSD_BACK,    	"Back 5", (void *)&psd4},  /*Back */
    {PSD,PSD_FRONT2,  	"Front6", (void *)&psd5},  /*Front Low */

    {WAIT,WAIT,"WAIT",(void *)&waitstates},
    {INFO,INFO,"INFO",(void *)&roboinfo},

    {IRTV,IRTV,"IRTV",(void *)&irtv},
    {COMPASS,COMPASS,"COMPAS",(void *)&compass},
    {STARTMELODY,STARTMELODY,"Melody",0},
    /*{STARTIMAGE,STARTIMAGE,"Image",(void *)&startimage},*/

    {END_OF_HDT,UNKNOWN_SEMANTICS,"END",(void *)0}
};

