#ifndef MLP_H
#define MLP_H
#define _GNU_SOURCE
#include <math.h>
#include <stdio.h>
#include <time.h>
#include <stdlib.h>
#include"npara.h"




/*
in:
  N_in  - which is the input of the neural network (must be scaled to [0..1])
  w_in  - weights between input and hidden layer
  W_out - weights between hidden and output layer
out:
  N_hid which is the output activation of the hidden layer (usually not needed)
  N_out which is the output activation of the output layer
*/
void feedforward(double N_in[NIN], double N_hid[NHID], double N_out[NOUT], double w_in[NIN][NHID], double w_out[NHID][NOUT]);

/*
in:
  cycles number - of episodes the trainingdata is presented
  lerning_rate  - lerning rate
  dataset       - number of datasets
  batch         - switch between direct and batch lerning (0 - direct, 1 - batch)
out:
*/
void train(int cycles,double lerning_rate,int dataset,int batch, double train_in_data[MAXPATERN][NIN], double train_out_data[MAXPATERN][NOUT],double w_in [NIN][NHID], double w_out[NHID][NOUT]);

/*
in:
  dataset       - number of datasets
out:
  prints the netoutput to screen for all datasets
*/
void testnet(int dataset,double w_in [NIN][NHID], double w_out[NHID][NOUT], double train_in_data[MAXPATERN][NIN],double train_out_data[MAXPATERN][NOUT]);


/*
in:
  pointer to weights between input and hidden layer
  pointer to weights between hidden and output layer
out:
  randomly initilized weights
*/
void init_weights(double w_in[NIN][NHID], double w_out[NHID][NOUT]);

/*
in:
  pointer to weights between input and hidden layer
  pointer to weights between hidden and output layer
out:
  prints weights on screen
*/
void show_weights(double w_in [NIN][NHID], double w_out[NHID][NOUT]);


#endif
