#ifndef WAYPOINT_H
#define WAYPOINT_H
/****************************************************************************
waypoint.h - Created by Peter Mauger 03/04/01
Last Modified 12/10/01

waypoint contains all functions required to determine bearing and distance to a
given waypoint from the current position and heading
****************************************************************************/

#include "include.h"

/* Init_Wplist initialises a wplist struct
* returns: an empty wplist structure
*/
wplist Init_Wplist();

/* Get_Wplist_Total retrieves the total number of waypoints from the wplist

* inputs:  waypoints->waypoint list

* returns: total number of waypoints in list

*/

int Get_Wplist_Total(wplist waypoints);



/* Get_Wp gets the current waypoint from the waypoint list

* inputs:  waypoints->list of all waypoints    

*	   curr_wpnum->the number of the current wp (<total_waypoints)

*	   pos->variable for returning the position of the waypoint

* returns: INVALIDWPNUM if curr_wpnum out of range of list

*	   NOERROR otherwise

*/

error Get_Wp(wplist waypoints, int curr_wpnum, position *pos);



/* At_Wp determines whether the current GPS position is within the

* tolerance of a given waypoint

* inputs:  GPSpos->GPS position (lat,long)  

* 	   tolerance->radial distance around waypoint considered to be the

* 		      waypoint (metres)

* 	   at_wp->variable for returning whether plane is at waypoint

* returns: DIVZERO if a divide by zero occured

*	   NOERROR otherwise

*/

error At_Wp(planestate plane, double tolerance, bool *at_wp); 



/* Obtain_Wplist_From_File receives a list of waypoints which will be received through 
* a COM port.
* inputs:  COM_port->the port number which the list will be received through
*	   waypoints->variable for returning the list of waypoints
* returns: COMMERROR if the list was not received
*	   NOERROR otherwise
*/
error Obtain_Wplist_From_File(wplist *waypoints);

/* Obtain_Wplist_From_HFile finds the default waypoint list stored in the planeconst.h file 
* inputs:  waypoints->passes the list of waypoints so they can be returned
*/
void Obtain_Wplist_From_HFile(wplist *waypoints);

/* Parse_Waypoint parses each waypoint in the waypoint file
* inputs:  file_string->the set of characters from the file
*	   file_ptr->marks character currently being looked at in string
*	   WPpos->is the position found
* returns: WPFILEERROR if there was an invalid string in the file
*	   NOERROR otherwise
*/
error Parse_Waypoint( char *file_string, int *file_ptr, wplist *wps );

#endif 
