//## begin module%1.4%.codegen_version preserve=yes
//   Read the documentation to learn more about C++ code generator
//   versioning.
//## end module%1.4%.codegen_version

//## begin module%3D86D35000AA.cm preserve=no
//	  %X% %Q% %Z% %W%
//## end module%3D86D35000AA.cm

//## begin module%3D86D35000AA.cp preserve=no
//## end module%3D86D35000AA.cp

//## Module: Commander%3D86D35000AA; Pseudo Package specification
//## Source file: C:\Program Files\Rational\Rose\C++\source\Commander.h

#ifndef Commander_h
#define Commander_h 1

//## begin module%3D86D35000AA.additionalIncludes preserve=no
//## end module%3D86D35000AA.additionalIncludes

//## begin module%3D86D35000AA.includes preserve=yes
//## end module%3D86D35000AA.includes

// Communicator
#include "Communicator.h"
// Avoider
#include "Avoider.h"
// Pusher
#include "Pusher.h"
// Explorer
#include "Explorer.h"
// Thread
#include "Thread.h"
//## begin module%3D86D35000AA.additionalDeclarations preserve=yes
//## end module%3D86D35000AA.additionalDeclarations


//## begin Commander%3D86D35000AA.preface preserve=yes
//## end Commander%3D86D35000AA.preface

//## Class: Commander%3D86D35000AA
//	/**
//	Activates and switches between the behaviors of the
//	robot (current implementation: Exploring, Pushing,
//	Avoiding, Communicating. Communicating only when using
//	local communication - see system model). The decision
//	which behavior to activate is based on the current state
//	of the commander and the return code it receives from
//	the last activated behavior. Once a behavior has served
//	its purpose it will return with a result code. The
//	commander does not actively interrupt activated
//	behaviors.
//	@author Jia L. Du
//	 */
//## Category: <Top Level>
//## Persistence: Transient
//## Cardinality/Multiplicity: n



class Commander : public Thread  //## Inherits: <unnamed>%3D86D5A601D6
{
  //## begin Commander%3D86D35000AA.initialDeclarations preserve=yes
  //## end Commander%3D86D35000AA.initialDeclarations

  public:
    //## Constructors (specified)
      //## Operation: Commander%3D9EBEEF03DE
      //	/**
      //	Constructor for Commander. The parameters are passed to
      //	the Thread constructor
      //	@param name pointer to thread name
      //	@param stackSize size of thread stack
      //	@param priority thread priority (valid values are: MIN_
      //	PRI to MAX_PRI)
      //	@param id a unique thread id
      //	 */
      Commander (char* name, int stackSize, int priority, int id);
    // Additional Public Declarations
      //## begin Commander%3D86D35000AA.public preserve=yes
      //	/**
      //	Tells the commander that the calling behavior would like
      //	to sleep for at least n hundredth seconds
      //	@param hundredthSeconds
      //	 */
      void doSleep(int hundredthSeconds);
      //	/**
      //	Tells the commander that the current behavior has nothing
      //	to do right now and would like to cede control to another
      //	thread
      //	 */
      void doReschedule(void);

      //	/**
      //	According to C++ convention, methods cannot be static and
      //	virtual at once. In the initial design run was declared as
      //	virtual which results in dynamic binding. That means the
      //	program determines at run-time which run method to use,
      //	the one of the Thread base class or the one of the inheritor.
      //	Because we have to use staticRun, we cannot use the virtual
      //	keyword anymore. Without the virtual keyword the compiler
      //	determines at compile-time which run method is used, always
      //	the run method of the Thread base class. To ensure that the
      //	inheritor indeed uses its own run method, it is necessary to
      //	overwrite the thread initialization method (spawn) as well.
      //	@see staticRun
      //	@return true if successful
      //	*/
      bool spawn ();
      //## end Commander%3D86D35000AA.public

  protected:
    // Additional Protected Declarations
      //## begin Commander%3D86D35000AA.protected preserve=yes
      void run(void); //protected or private??
      
      //	/**
      //	Static wrapper method for run. It does nothing but to call run.
      //	That is necessary because the RoBIOS multi-tasking functions expect
      //	a pointer to a C-function (not a pointer to a C++ method) containing
      //	the code to be executed. Fortunately, pointer-to-static-C++-methods
      //	are compatible with regular pointer-to-C-functions. But the problem
      //	is that static methods can only use other static methods and variables.
      //	The reasons is that a static method, which is shared by all instances,
      //	would not know which non-static method or variable to use if there were
      //	multiple instances of the same class. Thus, the static property would
      //	have to be applied to all used (sub-)methods and (sub-) variables,
      //	and propagate through the whole class structure. By using staticRun,
      //	we can keep using our non-static run. If static methods cannot call
      //	non-static ones, how can staticRun call run? As aforementioned the
      //	reason why static method cannot use non-static members is because it
      //	is not clear which non-static member to use if there are multiple
      //	instances of the same class. That means staticRun needs a pointer
      //	to the instance whose run method is to be called. This pointer is
      //	stored in a static member variable called me.
      //	@see me
      //	*/
      static void staticRun(void); //protected or private??
      //## end Commander%3D86D35000AA.protected

  private:

    // Additional Private Declarations
      //## begin Commander%3D86D35000AA.private preserve=yes
      //	/**
      //	Stores a pointer to an instance of Commander
      //	@see staticRun
      //	*/
      static Commander* me;
      //## end Commander%3D86D35000AA.private

  private: //## implementation
    // Data Members for Class Attributes

      //## Attribute: state%3D90214802C6
      //	/**
      //	Used by the class to keep track of its current state.
      //	Possible states are Commander::EXPLORING,
      //	Commander::PUSHING, Commander::AVOIDING and
      //	Commander::COMMUNICATING (Note: Commander::COMMUNICATING
      //	only when local communication is used. See system model)
      //	 */
      //## begin Commander::state%3D90214802C6.attr preserve=no  private: int {U} -1
      int state;
      //## end Commander::state%3D90214802C6.attr

      //## Attribute: EXPLORING%3D9AB34601FE
      //	/**
      //	Used by the class to keep track of its own state
      //	*/
      //## begin Commander::EXPLORING%3D9AB34601FE.attr preserve=no  private: static int {UC} 0
      static const int EXPLORING;
      //## end Commander::EXPLORING%3D9AB34601FE.attr

      //## Attribute: PUSHING%3D9AB37502E4
      //	/**
      //	Used by the class to keep track of its own state
      //	*/
      //## begin Commander::PUSHING%3D9AB37502E4.attr preserve=no  private: static int {UC} 1
      static const int PUSHING;
      //## end Commander::PUSHING%3D9AB37502E4.attr

      //## Attribute: AVOIDING%3D9AB375038E
      //	/**
      //	Used by the class to keep track of its own state
      //	*/
      //## begin Commander::AVOIDING%3D9AB375038E.attr preserve=no  private: static int {UC} 2
      static const int AVOIDING;
      //## end Commander::AVOIDING%3D9AB375038E.attr

      //## Attribute: COMMUNICATING%3D9AB37601FE
      //	/**
      //	Used by the class to keep track of its own state
      //	*/
      //## begin Commander::COMMUNICATING%3D9AB37601FE.attr preserve=no  private: static int {UC} 3
      static const int COMMUNICATING;
      //## end Commander::COMMUNICATING%3D9AB37601FE.attr

    // Data Members for Associations

      //## Association: <unnamed>%3D86D3D0035C
      //## Role: Commander::<explorer>%3D86D3D10208
      //	/**
      //	The Commander switches to the Explorer behavior when
      //	necessary
      //	*/
      //## begin Commander::<explorer>%3D86D3D10208.role preserve=no  public: Explorer { -> RHN}
      Explorer explorer;
      //## end Commander::<explorer>%3D86D3D10208.role

      //## Association: <unnamed>%3D86D3D3006E
      //## Role: Commander::<pusher>%3D86D3D30258
      //	/**
      //	The Commander switches to the Pusher behavior when
      //	necessary
      //	*/
      //## begin Commander::<pusher>%3D86D3D30258.role preserve=no  public: Pusher { -> RHN}
      Pusher pusher;
      //## end Commander::<pusher>%3D86D3D30258.role

      //## Association: <unnamed>%3D86D3D50136
      //## Role: Commander::<avoider>%3D86D3D502EE
      //	/**
      //	The Commander switches to the Avoider behavior when
      //	necessary
      //	*/
      //## begin Commander::<avoider>%3D86D3D502EE.role preserve=no  public: Avoider { -> RHN}
      Avoider avoider;
      //## end Commander::<avoider>%3D86D3D502EE.role

      //## Association: <unnamed>%3D86D3D701C2
      //## Role: Commander::<communicator>%3D86D3D80032
      //	/**
      //	The Commander switches to the Communicator behavior when
      //	necessary
      //	*/
      //## begin Commander::<communicator>%3D86D3D80032.role preserve=no  public: Communicator { -> RHN}
      Communicator communicator;
      //## end Commander::<communicator>%3D86D3D80032.role

    // Additional Implementation Declarations
      //## begin Commander%3D86D35000AA.implementation preserve=yes
      //## end Commander%3D86D35000AA.implementation

};

//## begin Commander%3D86D35000AA.postscript preserve=yes
//## end Commander%3D86D35000AA.postscript

// Class Commander

//## begin module%3D86D35000AA.epilog preserve=yes
//## end module%3D86D35000AA.epilog


#endif
