//## begin module%1.4%.codegen_version preserve=yes
//   Read the documentation to learn more about C++ code generator
//   versioning.
//## end module%1.4%.codegen_version

//## begin module%3D86D3480028.cm preserve=no
//	  %X% %Q% %Z% %W%
//## end module%3D86D3480028.cm

//## begin module%3D86D3480028.cp preserve=no
//## end module%3D86D3480028.cp

//## Module: Starter%3D86D3480028; Pseudo Package specification
//## Source file: C:\Program Files\Rational\Rose\C++\source\Starter.h

#ifndef Starter_h
#define Starter_h 1

//## begin module%3D86D3480028.additionalIncludes preserve=no
//## end module%3D86D3480028.additionalIncludes

//## begin module%3D86D3480028.includes preserve=yes
//## end module%3D86D3480028.includes

// Broadcaster
#include "Broadcaster.h"
// SIR
#include "SIR.h"
// Commander
#include "Commander.h"
//## begin module%3D86D3480028.additionalDeclarations preserve=yes
extern Broadcaster g_broadcaster; //this is needed because:
//all threads must be spawn in main (before the multi-tasking is activated)
//so our Broadcaster must be spawn in main
//but then Starter needs access to this Broadcaster
//so we declared the broadcaster as global
//if (one day ;-) threads can be spawn during runtime
//then the Broadcaster can be created locally in Starter
//and does not need to be a pointer to the global instance
//anymore
extern Commander g_commander; //this is needed because:
//all threads must be spawn in main (before the multi-tasking is activated)
//so our Commander must be spawn in main
//but then Starter needs access to this Commander
//so we declared the commander as global
//if (one day ;-) threads can be spawn during runtime
//then the Commander can be created locally in Starter
//and does not need to be a pointer to the global instance
//anymore
//## end module%3D86D3480028.additionalDeclarations


//## begin Starter%3D86D3480028.preface preserve=yes
//## end Starter%3D86D3480028.preface

//## Class: Starter%3D86D3480028
//	/**
//	This class provides a point of entry for the user
//	interface to control the clustering algorithm. This
//	ensures that the functionality is separated and hidden
//	from the user interface. The class provides a few public
//	methods to start and stop the clustering.
//	@author Jia L. Du
//	 */
//## Category: <Top Level>
//## Persistence: Transient
//## Cardinality/Multiplicity: n



class Starter
{
  //## begin Starter%3D86D3480028.initialDeclarations preserve=yes
  //## end Starter%3D86D3480028.initialDeclarations

  public:
    //## Constructors (generated)
      Starter();



    //## Other Operations (specified)
      //## Operation: startClustering%3D901FC402D0
      //	/**
      //	Starts the clustering. The threads that form the
      //	clustering algorithm are set to ready for execution
      //	@see Thread::ready()
      //	 */
      void startClustering ();

      //## Operation: stopClustering%3D901FEF0046
      //	/**
      //	Stops the clustering. All threads that form the
      //	clustering algorithm are suspended. Program quits
      //	@see Thread::suspend()
      //	 */
      void stopClustering ();

    // Additional Public Declarations
      //## begin Starter%3D86D3480028.public preserve=yes
      //## end Starter%3D86D3480028.public

  protected:
    // Additional Protected Declarations
      //## begin Starter%3D86D3480028.protected preserve=yes
      //## end Starter%3D86D3480028.protected

  private:
    // Additional Private Declarations
      //## begin Starter%3D86D3480028.private preserve=yes
      //## end Starter%3D86D3480028.private

  private: //## implementation
    // Data Members for Class Attributes

      //## Attribute: state%3D901FA101CC
      //	/**
      //	Used by the class to keep track of its current state.
      //	Possible states are Starter::READY, Starter::RUNNING
      //	 */
      //## begin Starter::state%3D901FA101CC.attr preserve=no  private: int {U} -1
      int state;
      //## end Starter::state%3D901FA101CC.attr

      //## Attribute: READY%3D9ABDF20078
      //	/**
      //	Used by the class to keep track of its own state
      //	*/
      //## begin Starter::READY%3D9ABDF20078.attr preserve=no  private: static int {UC} 0
      static const int READY;
      //## end Starter::READY%3D9ABDF20078.attr

      //## Attribute: RUNNING%3D9ABE350046
      //	/**
      //	Used by the class to keep track of its own state
      //	*/
      //## begin Starter::RUNNING%3D9ABE350046.attr preserve=no  private: static int {UC} 1
      static const int RUNNING;
      //## end Starter::RUNNING%3D9ABE350046.attr

    // Data Members for Associations

      //## Association: <unnamed>%3D86D39E0302
      //## Role: Starter::<commander>%3D86D39F0172
      //	/**
      //	The Starter starts and stops the Commander thread
      //	*/
      //## begin Starter::<commander>%3D86D39F0172.role preserve=no  public: Commander { -> RHN}
      Commander *commander;
      //## end Starter::<commander>%3D86D39F0172.role

      //## Association: <unnamed>%3D86D3A3006E
      //## Role: Starter::<sIR>%3D86D3A3028A
      //	/**
      //	The Starter starts and stops the SIR thread
      //	*/
      //## begin Starter::<sir>%3D86D3A3028A.role preserve=no  public: SIR { -> RHN}
      SIR *sir;
      //## end Starter::<sir>%3D86D3A3028A.role

      //## Association: <unnamed>%3D86D3A7003C
      //## Role: Starter::<broadcaster>%3D86D3A70226
      //	/**
      //	The Starter starts and stops the Broadcaster
      //	thread
      //	*/
      //## begin Starter::<broadcaster>%3D86D3A70226.role preserve=no  public: Broadcaster { -> RHN}
      Broadcaster *broadcaster;
      //## end Starter::<broadcaster>%3D86D3A70226.role

    // Additional Implementation Declarations
      //## begin Starter%3D86D3480028.implementation preserve=yes
      //## end Starter%3D86D3480028.implementation

};

//## begin Starter%3D86D3480028.postscript preserve=yes
//## end Starter%3D86D3480028.postscript

// Class Starter

//## begin module%3D86D3480028.epilog preserve=yes
//## end module%3D86D3480028.epilog


#endif
