/// @file linktypes.cc
/// @author Joshua Petitt <petitj01@tartarus.uwa.edu.au>
/// @author Stefan Schmitt <sschmitt@ee.uwa.edu.au>
/// @version 1.0
/// @date 2003-07
///  
/// Implements behavior.hh

#include "behavior/linktypes.hh"

namespace EyeMind {


SpeedLink::SpeedLink() : SignalLink()
{
	memset(&speed, 0, sizeof(SpeedType));
	memset(&next_speed, 0, sizeof(SpeedType));
	generic = false;
}


void SpeedLink::Speed(const SpeedType& s)
{
	next_speed = s;
	updated = true;
}



bool SpeedLink::Update()
{
	speed = next_speed;
	SignalLink::Update();
	return true;
}



DistanceLink::DistanceLink() : SignalLink()
{
	memset(&dist, 0, sizeof dist);
	memset(&next_dist, 0, sizeof next_dist);
	generic = false;
}


void DistanceLink::Distances(const DistancesType& d)
{
	next_dist = d;
	updated = true;
}


bool DistanceLink::Update()
{
	dist = next_dist;
	SignalLink::Update();

	return true;
}



ImageLink::ImageLink() : SignalLink()
{
	image = NULL;
	generic = false;
}


void ImageLink::Image(colimage* i)
{
	image = i;
	updated = true;
}


#if 0
PositionLink::PositionLink() : SignalLink()
{
	memset(&pos, 0, sizeof pos);
	memset(&next_pos, 0, sizeof next_pos);
}


void PositionLink::Position(const PositionType& p)
{
	next_pos = p;
	updated = true;
}


bool PositionLink::Update()
{
	pos = next_pos;
	SignalLink::Update();

	return true;
}



PolarLink::PolarLink() : SignalLink()
{
	memset(&coord, 0, sizeof coord);
	memset(&next_coord, 0, sizeof next_coord);
	generic = false;
}


void PolarLink::Polar(const PolarType& p)
{
	next_coord = p;
	updated = true;
}


bool PolarLink::Update()
{
	coord = next_coord;
	SignalLink::Update();

	return true;
}
#endif

BallLink::BallLink() : SignalLink()
{
	memset(&ball, 0, sizeof ball);
	memset(&next_ball, 0, sizeof next_ball);
	generic = false;
}

void BallLink::Ball(const BallType& b)
{
	next_ball = b;
	updated = true;
}


bool BallLink::Update()
{
	ball = next_ball;
	SignalLink::Update();

	return true;
}


}; // namespace EyeMind

