/**@file stdc_linktypes.cc
 * 
 * Implements stdc_linktypes.hh
 *
 */ 

#include "behavior/stdc_linktypes.hh"


using namespace EyeMind;


/**
 * CharLink
 */

CharLink::CharLink() : SignalLink()
{
	value = (char) 0;
	next_value = (char) 0;

	generic = false;
}


void CharLink::Char(char c)
{
	next_value = c;
	updated = true;
}


bool CharLink::Update()
{
	value = next_value;
	SignalLink::Update();
	return true;
}


/**
 * CharPointerLink
 */
CharArrayLink::CharArrayLink() : SignalLink()
{
	value = (char) 0;
	next_value = (char) 0;

	generic = false;
}


void CharArrayLink::CharArray(char* c)
{
	next_value = c;
	updated = true;
}


bool CharArrayLink::Update()
{
	value = next_value;
	SignalLink::Update();
	return true;
}


/**
 * FloatLink
 */

FloatLink::FloatLink() : SignalLink()
{
	value = 0;
	next_value = 0;

	generic = false;
}


void FloatLink::Float(float v)
{
	next_value = v;
	updated = true;
}


bool FloatLink::Update()
{
	value = next_value;
	SignalLink::Update();

	return true;
}


/**
 * IntLink
 */

IntLink::IntLink() : SignalLink()
{
	value = 0;
	next_value = 0;

	generic = false;
}


void IntLink::Int(int v)
{
	next_value = v;
	updated = true;
}


bool IntLink::Update()
{
	value = next_value;
	SignalLink::Update();

	return true;
}





