/**@file dictionary.hh
 *
 * Implements a dictionary.
 *
 */

#ifndef DICTIONARY_HH
#define DICTIONARY_HH


#ifdef WIN32
	#include <map>
	#include <string>

	#pragma warning(disable:4786) // We know basic_string generates long names :-)

	using namespace std;
#endif

#ifdef EYEBOT
	#include "base/templates.hh"
	#include <string>
	#include "eyebot_behavior_types.h"

	#define INDEX_SIZE 4
	#define DICTIONARY_SIZE 4
	#define WORD_SIZE 8
	using namespace EyeMind;
#endif


/// A simple dictionary


class Dictionary
{
private:

#ifdef WIN32
	std::map< std::string , int > entries;
#endif

#ifdef EYEBOT
	dictionary_entry_t data[DICTIONARY_SIZE];
	Array<dictionary_entry_t, DICTIONARY_SIZE> catalog;
#endif

public:
	Dictionary();

	void Add(const char* name, int value);
	int Find(const char* name);		// find the value of a given word
	const char* Get(int);			// get the first word associated with a value

	#ifdef WIN32
	bool Load(const char* filename);
	#endif

	#ifdef EYEBOT
	bool Load();
	#endif

	int Size(){return catalog.Size();}	// return the size of the dictionary
	dictionary_entry_t* operator[](int i){return NULL;}
};




/// A simple index (maps integers to integers)
class Index
{
private:
#ifdef WIN32
	std::map< std::string , int > entries;
#endif

#ifdef EYEBOT
	typedef struct
	{
		int ref;
		int val;
	} entry_t;
	
	entry_t data[INDEX_SIZE];
	Array<entry_t, INDEX_SIZE> catalog;
#endif

public:
	Index();

	void Add(int reference, int value);
	int Find(int reference);

	#ifdef WIN32
	bool Load(const char* filename);
	#endif

	#ifdef EYEBOT
	bool Load();
	#endif
};





#endif //DICTIONARY_HH

