/**
 * Data for the Mind behaviors
 */

#ifndef EYEBOT_BEHAVIOR_DATA_H
#define EYEBOT_BEHAVIOR_DATA_H

#include "eyebot_behavior_types.h"

twowheeldrive_bt twowheeldrive_data = {
	0.022,   		// radius
	0.142			// width
};

findball_bt findball_data = {
	103,				// Hue
	12,				// Threshold (distance from Hue)
	210,				// intensity low theesh   446
	630,				// intensity high thresh  718
	19,				// K parameter (for detecting grey)
	510,				// threshold close
	5,				// required number of matching pixels (1 to 5)
};

trackheading_bt attack_data = {
	10,			// deadband (degrees)
	1.05,			// Gain (Kw) .85
	40,			// dband_psd
	1.0,			// left bias
	1.0,			// right bias
	0.8,			// velocity (fast/striking) when centred and lined-up
	0.4,			// velocity (slow) when centring.
	0.0,			// velocity (slow_ when turning.
	0.5,			// w velocity (when centring).
	45,			// max turn rate (degrees)
	0,			// compass offset (set to 180 to point to own-goal)
	0			// internal offset
};

trackheading_bt defend_data = {
	20,			// deadband (degrees)
	1.85,			// Gain (Kw) .85
	60,			// dband_psd
	1.0,			// left bias
	1.0,			// right bias
	0.3,			// velocity (fast/striking) when centred and lined-up
	0.3,			// velocity (slow) when centring.
	0.0,			// velocity (slow) when turning
	0.4,			// w velocity (when centring).
	180,			// max turn rate (degrees)
	180,			// compass offset (set to 180 to point to own-goal)
	  0			// internal offset
};


trackheading_bt attackball_data = {
	20,			// deadband (degrees)
	1.05,			// Gain (Kw) .85
	60,			// dband_psd
	1.0,			// left bias
	1.0,			// right bias
	0.4,			// velocity (fast/striking) when centred and lined-up
	0.3,			// velocity (slow) when centring.
	0.3,			// w velocity (when centring).
	0.0,			..
	20,			// max turn rate (degrees)
	30,			// compass offset (set to 180 to point to own-goal)
	2			// internal offset
};

vwdrive_bt vwdrive_data = {
	-10,			// axle angular-velocity limit low
	10,			// axle angular-velocity limit high
	// PID control parameters with 1st order approximation
	5.0,			// Kp
	0.07,			// Reset time (KI??)
	0.0			// rate time  (KD??)
};

motorcontrol_bt motorcontrol_data = {
	// detect motor is stalled:
	40,			// time-units until stall is declared
	0.01			// angular velocity deadband
};

turnhead_bt turnhead_data = {
	0.35,			// Kp
	0.05,			// deadband
	// Ball close thesholds:
	9.0,				// range close (less then)
	30.0				// phi close ( between +/- degrees)
};

turncommand_bt turncommand_data = {
	0.0155,			// v/r gain.
	2.1			// w/phi gain.
};

dcmotor_bt dcmotor_data = {
	540,			// ticks per revolution
	0.01			// motor timebase (seconds)
};

centre_bt centre_data = {
	40,			// deadband (psd-units)
	0.02,			// gain
	0.7,			// left PSD bias
	1.0,			// right PSD bias
	40,			// max rate of turn (degrees)
	0.05,			// velocity component when turning
	0.8			// velocity component when lined-up and trying to score
};

avoid_bt avoid_data = {
	100,			//distance to avoid (side) (PSD units);
	 90,			//distance to avoid (front);
	 10,			//distance to avoid (back);
	50,			//ball threshold low
	80,			//ball threshold hi
	1.0,			//w_avoid_high;
	0.3,			//w_avoid_low;
	0.05, 			//v_avoid_high;
	0.0,			//v_avoid_low;
	3			// Grace. min time-units after seeing ball before avoid will test front PSD
};

wander_bt wander_data = {
	0.12,			// Forward wander velocity  0.1
	1.1,			// turning velocity 1.0
	11			// period (time-units) eg turns for 10, forward for 10, turn for 10, ...
};

reacquire_bt reacquire_data = {
	15,				// ticks until reacquire behavior exhausts
	6,					// start period
	-0.2,			// reacquire velocity (usually -ve so robot reverses)
	-0.5			// reacquire turn-rate.
};

motion_bt stop_data           = { 0.0, 0.0};
motion_bt drive_data          = { 0.8, 0.0};
motion_bt turnrightwide_data  = { 0.1,-2.0};
motion_bt turnright_data      = { 0.0,-1.0};
motion_bt turnleftwide_data   = { 0.1, 2.0};
motion_bt turnleft_data       = { 0.0, 0.8};
motion_bt backup_data         = {-1.0, 0.0};
motion_bt backupleft_data     = {-0.1, 0.6};
motion_bt backupright_data    = {-0.1,-0.6};

dictionary_t dictionary_data = {
	4,			// total number of words
	{{"stop\0   ",2},
	 {"play\0   ",3},
	 {"attack\0 ",0},
	 {"defend\0 ",1}}
};

#if 0
index_t irtvindex_data = {
	16,			// total number of commands
	{
	 {0x6142,0},	// 0
	 {0x61FD,1},	// 1 turn left wide
	 {0x6102,2},	// 2 drive straight
	 {0x60FD,3},	// 3 turn right wide
	 {0x6082,4},	// 4 turn left tight
	 {0x617D,5},	// 5 stop
	 {0x6182,6},	// 6 turn right tight
	 {0x607D,7},	// 7 backup left
	 {0x6042,8},	// 8 backup straight
	 {0x61BD,9},	// 9 backup right
	 {0x6182,10},	// power (use for all stop)
	 {0x6112,11},	// play
	 {0x606D,12},	// stop
	 {0x60ED,13},	// rewind
	 {0x61ED,14},	// fforward
	 {0x6166,15}	// OK (kickoff)
	}
};
#endif


index_t irtvindex_data = {
	6,			// total number of commands
	{
	 {0x6182,0},	// power (use for all stop)
	 {0x6112,1},	// play
	 {0x606D,2},	// stop
	 {0x60ED,3},	// rewind
	 {0x61ED,4},	// fforward
	 {0x6166,5}	// OK (kickoff)
	}
};

#endif //HDT_BEHAVIOR_DATA_H
