/* ----------------------------------------------------------------- */

/* 'ZAlgebraClass.h'									    */

/* Linear Algebra- Header- File							    */

/* 													    */

/* 	last modified 07/04/2003								    */

/* 	see ZAlgebraClass.cc for implementations				    */

/* 	maximum number of elements 16 (4x4), 					    */

/* 	this means: NO DYNAMIC RAM ALLOCATION!					    */

/* 													    */

/* 													    */

/* 	(C) Jochen Zimmermann								    */

/* ----------------------------------------------------------------- */



//avoid redefinition during static binding

#ifndef ZLA

#define ZLA



#include "ZHeaders.h"

/*

//needed headers, included via ZHeaders.h

#include "eyebot.h" 

#include "fastmath.h"

#include "ZHeaders.h"

*/







class LinearAlgebra

{

	friend class DenavitHartenberg;	

	/*DenavitHartenberg inherits this but also needs outbound access 

	for overloaded operator = in DenavitHartenberg::operator=() */

  	

    public:	

	LinearAlgebra();	

	/*standart constructor for initialisations*/

	

	LinearAlgebra(double* data, int wrows=4, int wcolumns=4);

	/*constructor with initialisation-data*/

	

	LinearAlgebra(const LinearAlgebra& tocopy);

	/*copy-constructor*/

	

	

	LinearAlgebra  operator * (double scalar);

	/*multiplies calling instance (matrix or vector) by scalar and 

	returns the result without changing calling instance*/

	

	LinearAlgebra  operator *=(double scalar);

	/*multiplies calling instance (matrix or vector) by scalar and 

	stzores the result in the calling instance*/

	

	LinearAlgebra  operator * (const  LinearAlgebra& lag);

	/*multiplies calling instance with lag, determines wether a 

	matrix-matrix-, matrix-vector-, or vector-vector-multiplication

	has to be performed, returns the result without changing the 

	calling instance*/

	

	LinearAlgebra  operator *=(const  LinearAlgebra& lag);

	/*multiplies calling instance with lag, determines wether a 

	matrix-matrix-, matrix-vector-, or vector-vector-multiplication

	has to be performed, returns the result in the calling instance*/

	

	LinearAlgebra  operator + (const  LinearAlgebra& lag);

	/*adds lag to the calling instance and checks if the addition can 

	be performed in a reasonable way, returns the without changing 

	the calling instance*/ 

	

	LinearAlgebra  operator +=(const  LinearAlgebra& lag);

	/*adds lag to the calling instance and checks if the addition can 

	be performed in a reasonable way, returns the result in the calling 

	instance*/ 

	

	LinearAlgebra  operator - (const  LinearAlgebra& lag);

	/*subtracts lag from the calling instance and checks if the 

	addition can be performed in a reasonable way, returns the result

	without changing the calling instance*/ 

	

	LinearAlgebra  operator -=(const  LinearAlgebra& lag);

	/*subtracts lag from the calling instance and checks if the 

	addition can be performed in a reasonable way, returns the result

	in the calling instance*/ 

	

	LinearAlgebra Equals(double* data, int wrows=4, int wcolumns=4);

	/*copies the passed data to the calling instance*/

	

	LinearAlgebra Plus(double* data, int wrows=4, int wcolumns=4);

	/*adds the passed data to the calling instance and checks if the 

	addition can be performed in a reasonable way, returns the without 

	changing the calling instance*/ 

	

	void   GetData(double* data,int wrows=4,int wcolumn=4,int firstrow=1, int firstcolumn=1);

	/*returns the private members in passed buffer data, by the chosen range*/

	

	double Absolute();

	/*returns the absolute of a vector if calling instance is a vector, 

	returns the determinant of a matrix if the calling instance is a matrix*/

	

	double Det();

	/*returns the determinant of a matrix if the calling instance is a matrix*/

	

	bool   IsMatrix();

	/*returns wether the calling instance is a matrix or not*/

	

	bool   IsVector();

	/*returns wether the calling instance is a vector or not*/

	

	int    GetRows();

	/*returns the number of rows in calling instance*/

	

	int    GetColumns();

	/*returns the number of columns in calling instance*/

	

	//int   OwnSqrt(double x); 

	/*returns sqrt of x*/

	

	

    protected:

    

    	int 	

    	rows,

    	/*actual number of rows*/

    		

    	columns;

    	/*actual number of columns*/

    		

    	double matrix[4][4];

    	/*buffer for matrix data*/



//  private:

//	static const unsigned short sqrtlookup[360];

	/*look-up table for OwnSqrt*/

    	

};



#endif

