/* fileName: simple.c
 * purpose: print acc data from Jack-II biped to LCD
 * author: Jesse Pepper <peppe-jj@ee.uwa.edu.au>
 */

#include <eyebot.h>

/* from assembly subroutine */
int accinit();
int accreadX();
int accreadY();


int main( void )
	{
	char done=0;
	int key=0;
	int delay=50;

	accinit();

	LCDClear();
	LCDMenu( "dly", "", "", "quit" );
	LCDSetPos( 0, 0 );
	LCDPrintf( "accX:" );
	LCDSetPos( 1, 0 );
	LCDPrintf( "accY:" );

	while (!done)
		{
		LCDSetPos( 0, 6 );
		LCDPrintf( "%d\n", accreadX() );
		LCDSetPos( 1, 6 );
		LCDPrintf( "%d\n", accreadY() );

		key = KEYGet();
		
		switch (key)
			{
			case KEY1:
				delay += 20;
				delay %= 100;
				break;
			case KEY4:
				done = 1;
				break;
			default:
				break;
			}

		OSWait( delay );
		}
		
	return 0;
	}
