/* ----------------------------------------------------------------- */
/* Battery-Test by Klaus Schmitt     (k_schmit@informatik.uni-kl.de) */
/*                                            last changes: 19/05/97 */
/* ----------------------------------------------------------------- */
/* This program displays graphically the actual capacity of the      */
/* batteries.                                                        */
/* ----------------------------------------------------------------- */


#include "eyebot.h" 

int main ()
{
    int val;

    LCDSetPos(0,1);
    LCDPutString("Battery-Status");
    LCDMenu("","","","END");

    /* draw bounding box */
    LCDLine(1,25,126,25, 1);
    LCDLine(1,35,126,35, 1);
    LCDLine(0,25,0,35, 1);
    LCDLine(127,25,127,35, 1);
    /* get actual status and draw appropriate rectangle on the LCD */
    val=(OSGetAD(1)-550)*127/300;
    if(val>127)
    LCDArea(1,26,127,34,1);
    else if(val>0)
         LCDArea(1,26,val,34,1);
	
	while (KEYRead() != KEY4)
	{
        if(val != ((OSGetAD(1)-550)*127/300))
        {
            /* clear old status */
            LCDArea(1,26,val,34,0);
    	    /* get actual status and draw appropriate rectangle on the LCD */
            val=(OSGetAD(1)-550)*127/300;
            if(val>127) LCDArea(1,26,127,34,1);
            else if(val>0) 
	    	 LCDArea(1,26,val,34,1);
            LCDLine(127,25,127,35,1);
        }
	}
  return 0;
}

