/* **************************** */
/* Simple Multi-Tasking Example */
/* Thomas Braunl, UWA 2002      */
/* **************************** */

#include "eyebot.h"
#define SSIZE  4096

struct tcb *task1, *task2;

void mytask()
{ int id, i;
  id = OSGetUID(0); /* read slave id no. */
  for (i=1; i<=3; i++)
  { LCDPrintf("task %d : %d\n", id, i);
    OSReschedule();   /* transfer control */
  }
  OSKill(0);  /* terminate thread */
}


int main()
{ OSMTInit(COOP);  /* init multitasking */
  task1 = OSSpawn("t1", mytask, SSIZE, MIN_PRI, 1);
  task2 = OSSpawn("t2", mytask, SSIZE, MIN_PRI, 2);
  if(!task1 || !task2) OSPanic("spawn failed");

  OSReady(task1); /* set state of task1 to READY */
  OSReady(task2);
  OSReschedule(); /* start multitasking */

/* ---------------------------------------------------- */

  /* processing returns HERE, when no READY thread left */
  LCDPrintf("back to main");
  return 0;
};

