@echo off

gcc -m68332 -I%gcc%\m68k\include -I%mc%\include -ansi -pedantic -c -msoft-float LCD.cpp
gcc -m68332 -I%gcc%\m68k\include -I%mc%\include -ansi -pedantic -c -msoft-float Behavior.cpp
gcc -m68332 -I%gcc%\m68k\include -I%mc%\include -ansi -pedantic -c -msoft-float PSDs.cpp
gcc -m68332 -I%gcc%\m68k\include -I%mc%\include -ansi -pedantic -c -msoft-float ImageFilter.cpp
gcc -m68332 -I%gcc%\m68k\include -I%mc%\include -ansi -pedantic -c -msoft-float Camera.cpp

gcc -m68332 -I%gcc%\m68k\include -I%mc%\include -ansi -pedantic -c -msoft-float Keyboard.cpp
gcc -m68332 -I%gcc%\m68k\include -I%mc%\include -ansi -pedantic -c -msoft-float Thread.cpp
gcc -m68332 -I%gcc%\m68k\include -I%mc%\include -ansi -pedantic -c -msoft-float UI.cpp
gcc -m68332 -I%gcc%\m68k\include -I%mc%\include -ansi -pedantic -c -msoft-float Starter.cpp
gcc -m68332 -I%gcc%\m68k\include -I%mc%\include -ansi -pedantic -c -msoft-float Commander.cpp

gcc -m68332 -I%gcc%\m68k\include -I%mc%\include -ansi -pedantic -c -msoft-float Drive.cpp
gcc -m68332 -I%gcc%\m68k\include -I%mc%\include -ansi -pedantic -c -msoft-float Explorer.cpp
gcc -m68332 -I%gcc%\m68k\include -I%mc%\include -ansi -pedantic -c -msoft-float Pusher.cpp
gcc -m68332 -I%gcc%\m68k\include -I%mc%\include -ansi -pedantic -c -msoft-float Avoider.cpp
gcc -m68332 -I%gcc%\m68k\include -I%mc%\include -ansi -pedantic -c -msoft-float Communicator.cpp

gcc -m68332 -I%gcc%\m68k\include -I%mc%\include -ansi -pedantic -c -msoft-float Compass.cpp
gcc -m68332 -I%gcc%\m68k\include -I%mc%\include -ansi -pedantic -c -msoft-float Timer.cpp
gcc -m68332 -I%gcc%\m68k\include -I%mc%\include -ansi -pedantic -c -msoft-float Radio.cpp
gcc -m68332 -I%gcc%\m68k\include -I%mc%\include -ansi -pedantic -c -msoft-float CubeClustering.cpp
gcc -m68332 -I%gcc%\m68k\include -I%mc%\include -ansi -pedantic -c -msoft-float SIR.cpp

gcc -m68332 -I%gcc%\m68k\include -I%mc%\include -ansi -pedantic -c -msoft-float Broadcaster.cpp

ld -L%mc%\lib -T%mc%\ldfiles\robi-ram.ld -o cube.I LCD.o Behavior.o PSDs.o ImageFilter.o Camera.o Keyboard.o Thread.o UI.o Starter.o Commander.o Drive.o Explorer.o Pusher.o Avoider.o Communicator.o Compass.o Timer.o Radio.o CubeClustering.o SIR.o Broadcaster.o -lmym -lmyc -lmygcc -lrobi

objcopy -O srec cube.I cube.hex

srec2bin cube.hex >NUL

@echo on
