/**@file stdc_linktypes.hh
 *
 * Defines data links for standard C data types
 *
 */

#ifndef STDC_LINKTYPES_HH
#define STDC_LINKTYPES_HH

#include "behavior/behavior.hh"

//using namespace EyeMind{
//using namespace EyeMind;
namespace EyeMind{

/// CharLink SignalLink
///
/// passes single characters, buffered.
class CharLink : public SignalLink
{
private:
	char value;
	char next_value;

public:
	CharLink();

	virtual bool Update();

	virtual void Char(char c);
	char Char(){return value;}
};


/// CharArrayLink SignalLink
///
/// passes a pointer to a NULL terminated character array
class CharArrayLink : public SignalLink
{
private:
	char* value;
	char* next_value;

public:
	CharArrayLink();

	virtual bool Update();
	virtual void CharArray(char* p);
	char* CharArray(){return value;}
};

/// FloatLink SignalLink
///
/// passes single floating point value, buffered.
class FloatLink : public SignalLink
{
private:
	float value;
	float next_value;

public:
	FloatLink();

	virtual bool Update();

	virtual void Float(float v);
	float Float(){return value;}
};

/// IntLink SignalLink
///
/// passes single integer value, buffered.
class IntLink : public SignalLink
{
private:
	int value;
	int next_value;

public:
	IntLink();

	virtual bool Update();

	virtual void Int(int);
	int Int(){return value;}
};


}; // namespace EyeMind

#endif // STDC_LINKTYPES_HH
