/**@file hdt.h
 *
 * Defines the HDT (hardware description table) data type
 * and functions to operate on the table.
 *
 */


#ifndef __HDT_H
#define __HDT_H

/* C++ needs to know that types and declarations are C, not C++.  */
#ifdef	__cplusplus
# define __ROBIOS_BEGIN_DECLS	extern "C" {
# define __ROBIOS_END_DECLS	}
#else
# define __ROBIOS_BEGIN_DECLS
# define __ROBIOS_END_DECLS
#endif

__ROBIOS_BEGIN_DECLS


#define UNKNOWN_TYPE      0
#define UNKNOWN_SEMANTICS 0
#define END_OF_HDT       -1
#define CHECKSUM         -2

typedef int     (*TestFunc) (DeviceSemantics);
typedef char    String6[7];
typedef char    String10[11];


/* DTL entry structure */
typedef struct
{
  TypeID      group;
  String6     name;
  TestFunc    testfunc;
} DTL_entry_type;

/* HDT entry structure */
typedef struct
{
  TypeID              type_id;
  DeviceSemantics     semantics;
  String6             device_name;
  void*               data_area;
} HDT_entry_type;


/**
 * Function prototypes
 */

// See if the HDT is valid
int HDT_Validate(void);

// Find an entry in the HDT
void *HDT_FindEntry(TypeID,DeviceSemantics);

// Find the device semantics for a specific type
DeviceSemantics HDT_FindSemantics(TypeID , int);

// The number of defined types
int   HDT_TypeCount(TypeID);

// Get the name of the device
char* HDT_GetString(TypeID, DeviceSemantics);

__ROBIOS_END_DECLS

#endif //__HDT_H

