/* ----------------------------------------------------------------- */

/* 'ZPaint.cc'											    */

/* Painting Functions Header- File						         */

/* 													    */

/* 	last modified 07/04/2003								    */

/* 	see ZPaint.cc for implementations						    */

/* 													    */

/* 													    */

/* 													    */

/* 													    */

/* 	(C) Jochen Zimmermann								    */

/* ----------------------------------------------------------------- */



//avoid redefinition during static binding

#ifndef ZPAINT

#define ZPAINT



#include "ZHeaders.h"



/*

//needed headers, included via ZHeaders.h

#include "ZInfraRed.h"

*/



//Painting parameters

#define CENTREXR 30

#define CENTREXL 97

#define CENTREY  30

#define CENTREX  63

#define NUMBEROFPOSITIONS 10



class Display

{

    public:

	

	static Display* GetTheInstance();

	/*instance retriever*/

	

	

	bool   Init();

	/*initialises the display and member variables*/

	

	void   Clear();

	/*imitates LCDClear(), clears the display and sets cursor-position

	to (0,0)*/

	

	int    Print(const char format[], ...);

	/*imitates LCDPrintf, prints the formatted string 'format' to the

	display, can process a variable number of variables by using the 

	ellipsis operator ('...')*/

	

	int    Print(int x,int y,const char format[], ...);

	/*similar to Print above, sets cursor to position (x,y) before printing*/

	

	int    Print(LinearAlgebra toprint);

	/*special Print displays an LinearAlgebra object on the display. 

	Depending on the number of columns it could be one or two splash-screens*/

		

	double PaintExtensions(int leftx=CENTREXL,int lefty=CENTREY,int rightx=CENTREXR,int righty=CENTREY);

	/*paints two triangles on the display, representing the feet's boundaries*/

	

	double PaintExtensions(LinearAlgebra left,LinearAlgebra right);

	/*paints two triangles on the display, representing the feet's boundaries*/

	

	void   PaintCross (float *positionnew,  int identity,double resizefactor/*=0.5*/);

	/*paints a cross on the position given by positionnew. Identity choses 

	the shape (odd=+ even=x) and label(see define NUMBEROFPOSITIONS for 

	count ) of the cross*/

	

	void   PaintCross (float *positionnew,  int identity);

	/*overloaded, see above*/ 

	

	void   PaintCross (LinearAlgebra vector,int identity,double resizefactor/*=0.5*/);

	/*overloaded, see above*/ 

	

	void   PaintCross (LinearAlgebra vector,int identity);

	/*overloaded, see above*/ 

	

	void   PaintLoadBalance(double left,double right,int total);

	/*paint a horizontal bar on top of the screen, expressing the total 

	force excerted on every foot*/

		

	int    Menu(const char str1[],const char str2[],const char str3[],const char str4[]);

	/*imitates LCDMenu, displays menu-entries on the bottom of the display,

	from str1 on the left to str4 on the right*/

		

	

    private:

	

	float  positionold[2*NUMBEROFPOSITIONS];

	/*buffer for old positions of the painted crosses, needed to delete them

	if they are displayed on a new position*/

	

	double resize;

	/*factor needed for zooming and autozooming (zoom will be calculated 

	automatically during the call of painting methods)*/

		

		

	Display();

	/*standart constructor for initialisations*/

	

	static Display SingleInstance;	

	/*The Single Instance of this Class*/

	

};





#endif

