/**
 * A 3-3-3-2 backpropagation network
 */

#ifndef BACKPROP_3332_H
#define BACKPROP_3332_H

#define IN_SIZE  3			// network input layer size
#define HID_SIZE 3			// network hidden layer size
#define OUT_SIZE 2			// network output layer size

#define LEARNING_RATE 0.1		// network learning rate (use small number
					// for more stable training, but longer
					// training time. Use number near 1 for
					// faster training, but network may not converge.

/* GLOBAL DATA FOR NETWORK */
float x1[IN_SIZE];
float W1[HID_SIZE][IN_SIZE];
float y1[HID_SIZE];
float g1[HID_SIZE];


float x2[HID_SIZE];
float W2[HID_SIZE][HID_SIZE];
float y2[HID_SIZE];
float g2[HID_SIZE];

float x3[HID_SIZE];
float W3[OUT_SIZE][HID_SIZE];
float y3[OUT_SIZE];
float g3[OUT_SIZE];

// Create both layers.  Note that this intializes the layers
// with references to the memory allocated above.
layer_t layers[3] =	{
	{IN_SIZE,HID_SIZE,x1,&W1[0][0],y1,g1},
	{HID_SIZE,HID_SIZE,x2,&W2[0][0],y2,g2},
	{HID_SIZE,OUT_SIZE,x3,&W3[0][0],y3,g3},
};

// Create the network and initialize with the layers previously
// allocated.
network_t network = {3,LEARNING_RATE,layers};

#endif //BACKPROP_3332_H

