/// @file standard_behaviors.hh
/// @author Joshua Petitt <petitj01@tartarus.uwa.edu.au>
/// @version 1.0
/// @date 2003-07
///  
/// Declares behaviors for very basic functions.

#ifndef STANDARD_BEHAVIORS_HH
#define STANDARD_BEHAVIORS_HH

#include "mind/mind.hh"
#include "behavior/behavior.hh"
#include "behavior/stdc_linktypes.hh"

namespace EyeMind {

/// Deactivates the active id.
/// @arg Input: SignalLink
/// @arg Output: SignalLink

class Shutdown : public Behavior
{
private:
protected:
	virtual int Execute();

public:
	/// Default constructor.
	Shutdown();
};


/// A Behavior which selects from a set of Behaviors
/// based on the value of its input link.  Behaviors
/// MUST be attached in correct order.  The Behavior 
/// switch only excites one link on the output, as 
/// opposed to the normal Behavior which outputs on
/// all links.
/// @arg Input: IntLink
/// @arg Output: SignalLink
class BehaviorSwitch:public Behavior
{
private:
	int select;
protected:
	virtual int Execute();
public:
	BehaviorSwitch();
	void Excite(int signal);

	void Select(int i){select=i;}
};

BehaviorSwitch& operator>>(IntLink& l,BehaviorSwitch& o);
IntLink& operator<<(BehaviorSwitch& n, IntLink& i);


/// A Behavior which acts as a "root" attachment to the Id.
/// Use this Behavior to attach the behavior trees.  This Behavior
/// has a defualt threshold of -1, and outputs a 1 signal.
/// *this >> BehaviorRoot >> ... rest of tree
///@arg Input: SignalLink
///@arg Output: SignalLink
class BehaviorRoot : public Behavior
{
protected:
	virtual int Execute();
public:
	BehaviorRoot();
};

}; // namespace EyeMind

#endif // STANDARD_BEHAVIORS
