/**@file kernel.hh
 *
 * Mind kernel.  This file should not have to change for different 
 * applications of the Mind. Only one file should implement these
 * functions.  For the EyeBot, the functions are in eyemind_kernel.cc.
 * For a Windows machine, the functions are defined in winmind_kernel.cc.
 *
 * @author Joshua Petitt
 * @date 2003
 *
 */


#include "mind/mind.hh"

 ///< a "dummy" header that must define myId, myEgo and mySuperEgo
#include "mind_dummy.hh"

/// Main program
extern int main(int,char**);

// Define other programs if not purely reactive
#ifndef REACT
/// Master process
extern void Master();

/// Acting process
extern void Act(void);

/// Thinking process
extern void Think(void);
#endif


