/// @file classes_s03/output/soccer_actors.hh

#include "output/eyebot_actors.hh"


namespace Soccer03 {

using namespace EyeMind;

/**Kicker (servo) actor class. Derived from the servo class. (only for goalie).
 * @author Jarrod Bassan
 * @date 11-Jul-2003
 */
class KickerServo : public Servo
{
private:
	KickerServo() : Servo( SERVO10, 255 )
	{
		SafeLimits(152,255);
		CalibrateRange(-50.0,50.0);
	}

public:
	SINGLETON(KickerServo);

};

/**Head-tilt (servo) actor class. Derived from the servo class. (only for goalie).
 * @author Jarrod Bassan
 * @date 11-Jul-2003
 */
class TiltServo : public Servo
{
private:
	TiltServo() : Servo( SERVO11, 32 )
	{ 
		SafeLimits(24,132);
		CalibrateRange(-50.0,50.0);
	}

public:
	SINGLETON(TiltServo);

};


}; // namespace Soccer03

