/*
|
-----------------------------------------------------------------------------
| Filename: labcars.c
|
| Author:       Thomas Braunl   (braunl@ee.uwa.edu.au)
|
| Description:
| -------
| HDT data for Lab Cars with EyeBot MK4, UWA April 2002
| Correct odometry specs added by Jason Foo [foo-jr@ee.uwa.edu.au]
-----------------------------------------------------------------------------
*/

#define VERSION 1.80     /* User specific version nr. for information */
#define NAME "ES220"     /* controller name max. 7 chars, inform. only */
#define ID   1           /* Unique platform id (int), just for inform. */

#include <eyebot.h>

/* The HDT structure */
/*-------------------*/
int     magic = 123456789;
extern HDT_entry_type HDT[];
HDT_entry_type  *hdtbase = &HDT[0];

#include "types.h"
#include "const.h"
#include "rs232.h"
#include "irtv.h"
#include "IRnokia.h"
#include "cam.h"
#include "librobi/librobi.h"

/*dist0, dist1 and dist2 just valid for modified labcar 11*/


short dist0[128] = {  92, 92, 92, 92, 92, 92, 92, 92, 92, 92,
                      92, 92, 92, 92, 95, 97, 98,100,102,103,
		     105,107,109,110,112,113,115,117,119,121,
		     123,125,127,129,131,133,135,137,140,143,
		     146,149,152,155,158,161,164,167,170,174,
		     179,183,187,191,197,202,207,213,219,225,
		     231,236,244,249,254,260,267,274,281,290,
		     305,312,324,339,360,388,402,430,460,500,
		     500,500,500,500,500,500,500,500,500,500,
		     500,500,500,500,500,500,500,500,500,500,
		     500,500,500,500,500,500,500,500,500,500,
		     500,500,500,500,500,500,500,500,500,500,
		     500,500,500,500,500,500,500,500};

short dist1[128] = {  97, 97, 97, 97, 97, 97, 97, 97, 97, 97,
		      97, 97, 97, 98,100,103,105,107,109,111,
		     114,116,118,120,122,124,126,128,130,132,
		     135,137,140,142,145,148,150,152,155,158,
		     162,164,168,172,175,179,183,186,191,196,
		     200,204,209,215,220,225,230,235,241,248,
		     255,261,270,278,284,293,301,312,323,335,
		     347,355,367,382,395,411,424,441,455,464,
		     480,500,500,500,500,500,500,500,500,500,
		     500,500,500,500,500,500,500,500,500,500,
		     500,500,500,500,500,500,500,500,500,500,
		     500,500,500,500,500,500,500,500,500,500,
		     500,500,500,500,500,500,500,500 };

short dist2[128] = {  97, 97, 97, 97, 97, 97, 97, 97, 97, 97,
		      97, 97, 97, 97, 97, 97, 97, 97, 97, 97,
		      99, 101,102,104,105,106,107,109,111,113,
		      114,117,119,120,122,124,126,128,131,134,
		      137,139,142,145,148,151,153,157,160,164,
		      167,172,175,180,184,189,192,198,204,209,
		      215,223,228,236,242,250,260,270,280,290,
		      300,310,323,336,351,369,387,402,420,437,
		      455,484,500,500,500,500,500,500,500,500,
		      500,500,500,500,500,500,500,500,500,500,
		      500,500,500,500,500,500,500,500,500,500,
		      500,500,500,500,500,500,500,500,500,500,
		      500,500,500,500,500,500,500,500 };

short dist3[128] = { 60, 60, 60, 60, 60, 60, 60, 60, 60, 60,
                     60, 60, 60, 60, 60, 60, 60, 60, 60, 60,
		     60, 60, 60, 60, 60, 65, 69, 70, 73, 75,
		     76, 77, 79, 81, 84, 85, 87, 88, 89, 90,
		     93, 95, 96, 98,100,103,105,107,109,110,
		    112,114,116,117,119,121,126,127,129,131,
                    134,137,140,144,146,149,151,156,159,167,
		    170,175,179,183,188,195,200,205,210,220,
		    225,235,240,250,265,275,285,295,310,320,
                    340,350,370,380,400,410,440,460,490,530,
		    600,610,630,680,750,830,900,999,999,999,
		    999,999,999,999,999,999,999,999,999,999,
                    999,999,999,999,999,999,999,999};

BYTE motconv0[101]= { 0, 1, 2, 3, 4, 5, 6, 7, 8,
9,10,11,12,13,14,15,16,17,18,19,

20,21,22,23,24,25,26,27,28,29,30,31,32,33,34,35,36,37,38,39,

40,41,42,43,44,45,46,47,48,49,50,51,52,53,54,55,56,57,58,59,

60,61,62,63,64,65,66,67,68,69,70,71,72,73,74,75,76,77,78,79,

80,81,82,83,84,85,86,87,88,89,90,91,92,93,94,95,96,97,98,99,
                     100};

/* DC motors */
/* Motor A = left, Motor B = right */
motor_type motorA = {2, 0, TIMER1, 8191, (void*)sim_porte, 1, 0,
(BYTE*)0};
motor_type motorB = {2, 1, TIMER1, 8191, (void*)sim_porte, 2, 3,
(BYTE*)0};
quad_type  encoderA = {0, 3, 2, MOTOR_LEFT,  3907, 2.0};
quad_type  encoderB = {0, 4, 5, MOTOR_RIGHT, 3907, 2.0};
vw_type drive = {0, DIFFERENTIAL_DRIVE, {QUAD_LEFT, QUAD_RIGHT, 0.144}};

irtv_type irtv = {1, 12, TPU_HIGH_PRIO, REMOTE_ON, SPACE_CODE, 15, 0x0000, 0x03FF,DEFAULT_MODE, 1, -1, RC_RED, RC_GREEN,RC_YELLOW, RC_BLUE};

/* SERVOs */
/* type, TPU-channel, Timer2, 20ms period, 0.7ms min, 1.7ms max */
/* here: servo 1 has TPU channel 2, and so on                   */
servo_type servo1  = {2,  2, TIMER2, 20000, 700, 1700};
servo_type servo2  = {2,  3, TIMER2, 20000, 700, 1700};
servo_type servo3  = {2,  4, TIMER2, 20000, 700, 1700};
servo_type servo4  = {2,  5, TIMER2, 20000, 700, 1700};
servo_type servo5  = {2,  6, TIMER2, 20000, 700, 1700};
servo_type servo6  = {2,  7, TIMER2, 20000, 700, 1700};
servo_type servo7  = {2,  8, TIMER2, 20000, 700, 1700};
servo_type servo8  = {2,  9, TIMER2, 20000, 700, 1700};
servo_type servo9  = {2, 10, TIMER2, 20000, 700, 1700};
servo_type servo10 = {2, 11, TIMER2, 20000, 700, 1700};
servo_type servo11 = {2, 12, TIMER2, 20000, 700, 1700};
servo_type servo12 = {2, 13, TIMER2, 20000, 700, 1700};


/* PSD-infrared */
psd_type   psd0   = {0, 14, (BYTE*)IOBase, 0, AH, (BYTE*)IOBase, 0, AH,
(short*)&dist0};
psd_type   psd1   = {0, 14, (BYTE*)IOBase, 1, AH, (BYTE*)IOBase, 0, AH,
(short*)&dist1};
psd_type   psd2   = {0, 14, (BYTE*)IOBase, 2, AH, (BYTE*)IOBase, 0, AH,
(short*)&dist2};
psd_type   psd3   = {0, 14, (BYTE*)IOBase, 3, AH, (BYTE*)IOBase, 0, AH,
(short*)&dist3};
psd_type   psd4   = {0, 14, (BYTE*)sim_porte, 5, AH, (BYTE*)IOBase, 0, AH,
(short*)&dist3};
psd_type   psd5   = {0, 14, (BYTE*)sim_porte, 4, AH, (BYTE*)IOBase, 0, AH,
(short*)&dist3};
/*
compass_type compass = {0,6,(void*)IOBase, 5,(void*)IOBase, 6,
(BYTE*)IOBase, 5};

*/
/* EyeBot SUMMARY */
info_type roboinfo  =
{0,VEHICLE,SER115200,RTSCTS,SERIAL1,0,0,AUTOBRIGHTNESS,BATTERY_ON,33,VERSION,NAME,ID};

/* waitstates = 0..13, Fast Termination = 14, External = 15 */
/* Version, ROM, RAM, LCD, IO, Parallel+Serial2/3 */
/* 16MHz - 20Mhz */
/* waitstate_type waitstates = {0,3,0,1,0,2}; */
/* 21MHz - 41Mhz */
waitstate_type waitstates = {0,3,1,2,1,2};

/* include startup sound and image */
#include "startup.h"

/* this is a test HDT structure which contains ALL EyeBot hardware devices
*/
HDT_entry_type HDT[] =
{
    {MOTOR,MOTOR_LEFT, "MotA-L",(void *)&motorA},
    {MOTOR,MOTOR_RIGHT,"MotB-R",(void *)&motorB},
    {QUAD, QUAD_LEFT,  "LEFT",  (void *)&encoderA},
    {QUAD, QUAD_RIGHT, "RIGHT", (void *)&encoderB},
    {VW,VW,"Drive",(void *)&drive},

    {SERVO,SERVO12,"CAMERA",(void *)&servo12},

    {PSD,PSD_FRONT,    "P0-F",  (void *)&psd0},
    {PSD,PSD_LEFT,     "P1-L",  (void *)&psd1},
    {PSD,PSD_RIGHT,    "P2-R",  (void *)&psd2},
    {PSD,PSD_FRONT2,   "P3-Top",(void *)&psd3},

    {WAIT,WAIT,"WAIT",(void *)&waitstates},
    {INFO,INFO,"INFO",(void *)&roboinfo},

    {STARTIMAGE,STARTIMAGE,"Image",(void *)&startimage},
    /*{COMPASS,COMPASS,"COMPAS",(void *)&compass},*/

    /* {BUMP, BUMP_LEFT,"LEFT",(void *)&bumper0},   */
    {IRTV, IRTV,"IRTV",(void *)&irtv},
    /* MAGNET controlled via Dig-Out 1  (no HDT entry) */

    {END_OF_HDT,UNKNOWN_SEMANTICS,"END",(void *)0}
};
