/**
 * A 3-7-2 backpropagation network
 */

#ifndef BACKPROP_372_H
#define BACKPROP_372_H

#define IN_SIZE  3			// network input layer size
#define HID_SIZE 7			// network hidden layer size
#define OUT_SIZE 2			// network output layer size

#define LEARNING_RATE 0.1		// network learning rate (use small number
					// for more stable training, but longer
					// training time. Use number near 1 for
					// faster training, but network may not converge.

/* GLOBAL DATA FOR NETWORK */
float x1[IN_SIZE];
float W1[HID_SIZE][IN_SIZE];
float y1[HID_SIZE];
float g1[HID_SIZE];

float x2[HID_SIZE];
float W2[OUT_SIZE][HID_SIZE];
float y2[OUT_SIZE];
float g2[OUT_SIZE];

// Create both layers.  Note that this intializes the layers
// with references to the memory allocated above.
layer_t layers[2] =	{
	{IN_SIZE,HID_SIZE,x1,&W1[0][0],y1,g1},
	{HID_SIZE,OUT_SIZE,x2,&W2[0][0],y2,g2}
};

// Create the network and initialize with the layers previously
// allocated.
network_t network = {2,LEARNING_RATE,layers};

#endif //BACKPROP_372_H

