//## begin module%1.4%.codegen_version preserve=yes
//   Read the documentation to learn more about C++ code generator
//   versioning.
//## end module%1.4%.codegen_version

//## begin module%3D86D3FC0244.cm preserve=no
//	  %X% %Q% %Z% %W%
//## end module%3D86D3FC0244.cm

//## begin module%3D86D3FC0244.cp preserve=no
//## end module%3D86D3FC0244.cp

//## Module: Camera%3D86D3FC0244; Pseudo Package specification
//## Source file: C:\Program Files\Rational\Rose\C++\source\Camera.h

#ifndef Camera_h
#define Camera_h 1

//## begin module%3D86D3FC0244.additionalIncludes preserve=no
//## end module%3D86D3FC0244.additionalIncludes

//## begin module%3D86D3FC0244.includes preserve=yes
#include "eyebot.h"
//## end module%3D86D3FC0244.includes

//## begin module%3D86D3FC0244.additionalDeclarations preserve=yes
//## end module%3D86D3FC0244.additionalDeclarations


//## begin Camera%3D86D3FC0244.preface preserve=yes
//## end Camera%3D86D3FC0244.preface

//## Class: Camera%3D86D3FC0244
//	/**
//	This class provides methods to access the robot camera.
//	The class is designed as a singleton class. This is to
//	ensure that the camera initialization process is only
//	executed once as multiple initializations will result in
//	errors. So at any given time there is at most one
//	instance of the class. The method Camera::getCamera() is
//	used to access that instance.
//	@author Jia L. Du
//	 */
//## Category: <Top Level>
//## Persistence: Transient
//## Cardinality/Multiplicity: n



class Camera 
{
  //## begin Camera%3D86D3FC0244.initialDeclarations preserve=yes
  //## end Camera%3D86D3FC0244.initialDeclarations

  public:

    //## Other Operations (specified)
      //## Operation: initialize%3D92923E00DC
      //	/**
      //	Initializes the camera for usage. Should automatically be called by the
      //  constructor. But as the EyeSim simulator is not able to execute RoBIOS
      //  library functions in class constructors, we have declared this method as
      //  public and need to call this method manually in main
      //	@return true if successful
      //	*/
      bool initialize ();

      //## Operation: getCamera%3D9AA24401FE
      //	/**
      //	This method is used to get the instance of this
      //	singleton class
      //	@return A pointer to the instance
      //	 */
      static Camera* getCamera ();

      //## Operation: getFrame%3D9292500154
      //	/**
      //	This methods takes an image from the color camera and
      //	converts it to grayscale
      //	@param aImage A reference to the image
      //	 */
      void getFrame (image& aImage);

      //## Operation: getColorFrame%3D92926000DC
      //	/**
      //	This methods takes an image from the color camera
      //	@param aColorImage A reference to the color image
      //	 */
      void getColorFrame (colimage& aColorImage);

    // Additional Public Declarations
      //## begin Camera%3D86D3FC0244.public preserve=yes
      //## end Camera%3D86D3FC0244.public

  protected:
    //## Constructors (generated)
      Camera();

    //## Destructor (generated)
      ~Camera();


    //## Other Operations (specified)

      //## Operation: release%3D92923E010E
      //	/**
      //	Releases the camera after usage. Is automatically called by the
      //  destructor
      //	@return true if successful
      //	 */
      bool release ();

    // Additional Protected Declarations
      //## begin Camera%3D86D3FC0244.protected preserve=yes
      //## end Camera%3D86D3FC0244.protected

  private:
    // Additional Private Declarations
      //## begin Camera%3D86D3FC0244.private preserve=yes
      //	/**
      //	Used internally to control the camera servo
      //	 */
      ServoHandle cameraServoHandle;
      //## end Camera%3D86D3FC0244.private

  private: //## implementation
    // Data Members for Class Attributes

      //## Attribute: aCamera%3D9AA26D032A
      //	/**
      //	The single instance that exists of this class
      //	@see Camera::getCamera()
      //	*/
      //## begin Camera::aCamera%3D9AA26D032A.attr preserve=no  private: static Camera {U}
      static Camera aCamera;
      //## end Camera::aCamera%3D9AA26D032A.attr

    // Additional Implementation Declarations
      //## begin Camera%3D86D3FC0244.implementation preserve=yes
      //## end Camera%3D86D3FC0244.implementation

};

//## begin Camera%3D86D3FC0244.postscript preserve=yes
//## end Camera%3D86D3FC0244.postscript

// Class Camera

//## begin module%3D86D3FC0244.epilog preserve=yes
//## end module%3D86D3FC0244.epilog


#endif
