
#ifndef Compass_h
#define Compass_h 1

#include "eyebot.h"

//	/**
//	This class provides methods to access the compass.
//	The class is designed as a singleton class.
//	This is to ensure that the initialization process is
//	executed only once as multiple initializations will
//	result in errors. So at any given time there is at most
//	one instance of the class. The method Compass::getCompass()
//	can be used to access that instance.
//	@author Jia L. Du
//	 */



class Compass
{

  public:

      //	/**
      //	Initializes the compass for usage. Should automatically be called by the
      //  constructor. But as the EyeSim simulator is not able to execute RoBIOS
      //  library functions in class constructors, we have declared this method as
      //  public and need to call this method manually in main
      //	@return true if successful
      //	*/
      bool initialize ();

      //	/**
      //	This method is used to get the instance of this
      //	singleton class
      //	@return A pointer to the instance
      //	 */
      static Compass* getCompass ();

      //	/**
      //	This method is used to get the heading of the robot
      //  in degree (between 0 and 359)
      //	@return The heading of the robot in degree
      //	 */
      int getHeading ();

  protected:
    //Constructors
      Compass();

    //Destructor
      ~Compass();


      //	/**
      //	Releases the compass after usage. Is automatically called by the
      //  destructor
      //	@return true if successful
      //	 */
      bool release ();



  private:
      //	/**
      //	The single instance that exists of this class
      //	@see Compass::getCompass()
      //	*/
      static Compass aCompass;


};



#endif
