/**@file soccer_states.hh
 *
 */

 
#ifndef SOCCER_STATES_HH
#define SOCCER_STATES_HH

#include "state/state.hh"
#include "behavior/vision_behaviors.hh"

/**
 * State this is true if the robot is playing the game
 */
 
class PlayingSoccerState : public State
{
friend SpeedLink& operator>>(PlayingSoccerState& n, SpeedLink& o);
friend StringLink& operator<<(PlayingSoccerState& n, StringLink& i);

private:
SpeedLink* speed;
StringLink* string;

public:

	PlayingSoccerState()
	{
		speed = NULL;
		string = NULL;
	}

	virtual tristate Evaluate()
	{
		value = TRISTATE_UNKNOWN;

		if(string!=NULL && speed!=NULL)
		{
			if(!strcmp(string->String(),"go"))
			{
				if(value!=TRISTATE_TRUE)
				{
					// set the speed signal to zero so other behaviors can override
					speed->Signal(0);
					speed->Update();
				}
				value = TRISTATE_TRUE;
			}

			if(!strcmp(string->String(),"stop"))
			{
				value = TRISTATE_FALSE;
			}

			DEBUG_PRINTF("state %d\n",value);
		}

		return value;
	}

	int Resolve()
	{
		if(speed!=NULL)
		{
			// set speed to zero so robot stops moving
			speed->Speed().v = 0.0;
			speed->Speed().w = 0.0;

			// excite the link
			speed->Signal(EXCITE_EXT);
			speed->Update();
		}

		return 0;
	}

};


inline SpeedLink& operator>>(PlayingSoccerState& n, SpeedLink& o)
{
	n.speed = &o;
	StateOutputToSignalLink(n,o);
	return o;
}

inline StringLink& operator<<(PlayingSoccerState& n, StringLink& i)
{
	n.string = &i;
	StateInputToSignalLink(n,i);
	return i;
}



/**
 * State that is true if the robot can "see" the soccerball
 */

class SeeBallState : public State
{
private:
	


public:
	SeeBallState()
	{
		//findball = FindBall::I();
	}

	tristate Evaluate()
	{
		DEBUG_PRINT("Seeball state\n");
		//if(findball!=NULL)
		//{
		//	if(findball.FoundBall())
		//	{
		//		value = FUZZY_TRUE;
		//	}
		//	else
		//	{
		//		return FUZZY_FALSE;
		//	}
		//}

		value = TRISTATE_TRUE;
		return value;
	}

	int Resolve()
	{
		DEBUG_PRINT("Resolving");
		//findball.Excite(1);
		return 0;
	}
};


/**
 * State that is true if the robot has possession of the soccerball
 */
class HaveBallState : public State
{
private:


public:
	HaveBallState()
	{
	}

	tristate Evaluate()
	{
		return TRISTATE_FALSE;
	}

	int Resolve()
	{
		return 0;
	}

};


#endif //SOCCER_STATES_HH
