/**
 * HDT for CIIPS Glory 03
 *
 */

#define VERSION 03  	 /* User specific version nr. for information */
#define NAME "Glory"     /* controller name max. 7 chars, inform. only */
#define ID   3          /* Unique platform id (int), just for inform. */

#include "eyebot_hardware_sem.h"
#include "eyebot_hardware_types.h"
#include "eyebot_behavior_sem.h"
#include "eyebot_behavior_types.h"


/* The HDT structure */
/*-------------------*/
int magic = 123456789;
extern HDT_entry_type HDT[];
HDT_entry_type  *hdtbase = &HDT[0];


#include "startup.h"			// startup melody and image
#include "eyebot_hardware_data.h"	// Lab Car hardware
#include "soccer_behavior_data.h"	// behavior data

/* this is a test HDT structure which contains ALL EyeBot hardware devices
*/
HDT_entry_type HDT[] =
{
	/* ROBOT HARDWARE ENTRIES */
	{INFO,INFO,"INFO",(void *)&roboinfo},
	{WAIT,WAIT,"WAIT",(void *)&waitstates},

	{MOTOR,MOTOR_RIGHT, "MotA-R",(void*)&motorA},
	{MOTOR,MOTOR_LEFT,  "MotB-L",(void*)&motorB},
	{QUAD, QUAD_RIGHT, "RIGHT", (void*)&encoderA},
	{QUAD, QUAD_LEFT,  "LEFT",  (void*)&encoderB},

	{SERVO,SERVO12,"CAMERA",(void*)&servo12},

	{PSD,PSD_FRONT, "P0-F",  (void*)&psd0},
	{PSD,PSD_LEFT,  "P1-L",  (void*)&psd1},
	{PSD,PSD_RIGHT, "P2-R",  (void*)&psd2},
	{PSD,PSD_BACK,  "P3-B",  (void*)&psd3},

	{COMPASS,COMPASS,"COMPAS",(void*)&compass},
	{IRTV,IRTV,"IRTV",(void*)&irtv},

	{B_TWOWHEELDRIVE,	0,"",(void*)&twowheeldrive_data},
	{B_FINDBALL,		0,"",(void*)&findball_data},
	{B_VWDRIVE,		0,"",(void*)&vwdrive_data},
	{B_TRACKHEADING,	B_ATTACK,"",(void*)&attack_data},
	{B_TRACKHEADING,	B_DEFEND,"",(void*)&defend_data},
	{B_TRACKHEADING,	B_ATTACKBALL,"",(void*)&attackball_data},
	{B_MOTORCONTROL,	0,"",(void*)&motorcontrol_data},
	{B_STALL,		0,"",(void*)&stall_data},
	{B_TURNHEAD,		0,"",(void*)&turnhead_data},
	{B_TURNCOMMAND,		0,"",(void*)&turncommand_data},
	{B_DCMOTOR,		0,"",(void*)&dcmotor_data},
	{B_CENTRE,		0,"",(void*)&centre_data},
	{B_AVOID,		0,"",(void*)&avoid_data},
	{B_WANDER,		0,"",(void*)&wander_data},
	{B_REACQUIRE,		0,"",(void*)&reacquire_data},

	{B_MOTION,B_MOTION_STOP,"",(void*) &stop_data},
	{B_MOTION,B_MOTION_KICKOFF,"",(void*)&kickoff_data},

	/* MISC DATA */
	// Player info
	{PLAYER,0,"",(void*)&player_data},

	// Dictionary
	{DICTIONARY,0,"",(void*)&dictionary_data},

	// IRTV index
	{INDEX,0,"",(void*)&irtvindex_data},

	// Start-up image
	{STARTIMAGE,STARTIMAGE,"Image",(void *)&startimage},

	{END_OF_HDT,UNKNOWN_SEMANTICS,"END",(void *)0}
};
