/*##############################################*/
/* Bluetooth Setup for HandyPort*/
/* Christian Schmitz September 2004*/
/* University of Western Australia*/
/* Fachhochschule Koblenz, Germany*/
/*##############################################*/
 
 
#include "eyebot.h"
 
static char *speed[5] = {"  9600"," 19200"," 38400"," 57600","115200"};
static char *handshake[2] = {"  NONE", "RTSCTS"};
static int column;
static int row;
char** actual_speed;//pointer to the actual speed setting
char** actual_hsk;//pointer to the actual handshake setting
 
int speed_or_hsk();//decides if cursor is on speed(return 0) or hsk(return 1);
void speedup();//changes speed on display and actual_speed pointer upwards
void speeddown();//changes speed on display and actual_speed pointer downwards
void handshakeup();//changes handshake on display and actual_speed pointer upwards
void handshakedown();//changes handshake on display and actual_speed pointer downwards
void sendToHandyport(BYTE baud, BYTE hardware);//send commands and settings
BYTE getSpeed();//get current speed setting from speedpointer
BYTE getHandshake();//get current handshake setting from handshake pointer
 
int main()
{ 
int error=0;
BYTE c = ((BYTE)0x0d);//equals ENTER-Key
int key;
actual_speed = &speed[0];
actual_hsk = &handshake[0]; //
int pos;
BYTE speed;
BYTE hsk;
 
LCDPutString("Bluetooth SETUP\n");
LCDPutString("----------------");
LCDPutString("Press RST buttonWait 5sec after\nLNK is flashing.Then press ETR");

LCDMenu("ETR"," "," ","END");
 
error = OSInitRS232(SER9600, NONE, SERIAL1);//Open RS232 on SERIAL1
if(error)
{
LCDPrintf("RS232 error\n");
  return 1;
    }
 
  key = KEYGet();
  switch(key)
  {
  case(KEY4): //END - key
    return 1;break;
  
  case(KEY1)://ENTER - key
  error = OSSendCharRS232((char)c, SERIAL1);
  if (error)
    {
      LCDPrintf("RS232 send error");
      return 1;
    }
    else
    {
    LCDClear();
    LCDPutString("Bluetooth SETUP\n");
    LCDPutString("----------------\n");
    LCDPutString("Speed: 9600\n");
    LCDPutString("Handske: NONE\n");
    LCDMenu("+","-","Nxt","END");
    LCDSetChar (3, 15, '*');
       LCDSetPos(3,15);
   }
}

while(1)
 {
 key = KEYGet();
 //LCDMode(CURSOR);
 switch(key)
 {
 case(KEY4): 
    speed = getSpeed();
    hsk = getHandshake();
    sendToHandyport(speed, hsk);
    return 0;break;
    
 case(KEY3)://Next-key, switch between speed and handshake
    LCDGetPos(&row, &column);
    if(row == 3)
    {
    LCDSetChar(row, column, ' ');
    LCDSetChar(row+1, column, '*');
    LCDSetPos(row+1, column);
   }
          else 
          {
          LCDSetChar(row, column, ' ');
          LCDSetChar(row-1, column, '*');
          LCDSetPos(row-1, column);
    }
     break;
     
 case(KEY2): //+key increases value
    pos = speed_or_hsk();
    if(pos)
    handshakedown();
   else
   speeddown();
    
    break;
 
 case(KEY1): //-key decreases value
    pos = speed_or_hsk();
    if(pos)
    handshakeup();
   else
   speedup();
         break;
}
 


}

}
 
//####################################
//decides wether cursor is on speed or handshake
//returns 0 for speed, 1 for handshake
 
int speed_or_hsk()
{
LCDGetPos(&row, &column);
 if(row == 3)
  return 0;
    else
    return 1;
}
 
//####################################
//counts speed up

void speedup()
{
if(actual_speed == &speed[4])
actual_speed = &speed[0];
else
actual_speed++;
LCDSetString(3,7,*actual_speed);

}
 
//###################################
//counts speed down
void speeddown()
{
if(actual_speed == &speed[0])
actual_speed = &speed[4];
else
actual_speed--;
LCDSetString(3,7,*actual_speed);
}
 
//###################################
//changes flowcontrol -up
 
void handshakeup()
{
if(actual_hsk == &handshake[1])
actual_hsk = &handshake[0];
else
 actual_hsk++;
LCDSetString(4,8,*actual_hsk);

}
 
//###################################
//changes flowcontrol -down
 
void handshakedown()
{
if(actual_hsk == &handshake[0])
actual_hsk = &handshake[1];
else
actual_hsk--;
LCDSetString(4,8,*actual_hsk);
}
 
 
//###################################
//commands send to Handyport to change
//baudrate, flowcontrol and to save settings
 
void sendToHandyport(BYTE baud, BYTE hardware)
{
char c;
c = ((BYTE)0x42);//'B' baudrate
OSSendCharRS232((char)c, SERIAL1);
  c = (baud);//speed
  OSSendCharRS232((char)c, SERIAL1);
  c = ((BYTE)0x46);//'F' Flow control
  OSSendCharRS232((char)c, SERIAL1);
  c = (hardware);//handshake
  OSSendCharRS232((char)c, SERIAL1);
  c = ((BYTE)0x58);//'X' to save
  OSSendCharRS232((char)c, SERIAL1);
}
 
 
//#######################################
//get speed from pointerposition
//returns the byte command that must be send to the handyport
//i.e. '5'(0x35) equals 38400 baud
 
BYTE getSpeed()
{
int i;
BYTE b = ((BYTE) 0x33);

for(i=0; i<5; i++)
{
if(actual_speed == &speed[i])
{
return b;
}
b++;
}
return 0;
}
 
 
//#########################################
// get flowcontrol from pointerposition
//returns the byte command that must be send to the handyport
 
BYTE getHandshake()
{
int i;
BYTE b = ((BYTE) 0x30);

for(i=0; i<2; i++)
{
if(actual_hsk == &handshake[i])
{
return b;
}
b++;
}
return 0;
}
