/* ----------------------------------------------------------------- */

/* 'ZServo.h'											    */

/* Header for ZServo.cc			 					         */

/* 													    */

/* 	last modified 07/04/2003								    */

/* 	used to define macros for servo- handling				    */

/* 													    */

/* 													    */

/* 													    */

/* 													    */

/* 	(C) Jochen Zimmermann								    */

/* ----------------------------------------------------------------- */





/****Semantics as set in HDT**********



 +Right leg from top to bottom:

 ----------------------------------

 right arm      	= R_Arm

 right hip side 	= R_HipSide

 right hip bend 	= R_HipBend

 right knee		= R_Knee

 right ankle bend	= R_AnkleBend

 right ankle side	= R_AnkleSide

 

 +Left leg from top to bottom:

 ----------------------------------

 left arm			= L_Arm

 left hip side		= L_HipSide

 left hip bend		= L_HipBend

 left knee		= L_Knee

 left ankle bend	= L_AnkleBend

 left ankle side	= L_AnkleSide



*************************************/



//avoid redefinition during static binding

#ifndef ZSERVO

#define ZSERVO



#include "ZHeaders.h"

/*

//needed headers, included via ZHeaders.h

#include "eyebot.h"

#include "fastmath.h"

*/



/*****Re-defines for internal use****/

#define NUMBEROFSERVOS 10

#define RHIPS 0

#define LHIPS 1

#define RHIPB 2

#define LHIPB 3

#define RKNEE 4

#define LKNEE 5

#define RANKB 6

#define LANKB 7

#define RANKS 8

#define LANKS 9



#define BODY -1

#define RTHIGH 2

#define LTHIGH 3

#define RSHANK 4

#define LSHANK 5

#define RFOOT 8

#define LFOOT 9



/* not connected 

#define RARM  10

#define LARM  11

*/

#define HIPDISTANCE 56



class Servo

{

    public:

	

	static Servo* GetTheInstance();

	/*instance retriever*/

	

	void Init();

	/*initialises servos and members*/

	

	void Release();

	/*releases servos, necessary to call before main-exit*/

	

	int  Set (int* position, int speed);

	/*drives servos to absolute positions with chosen speed*/

	

	void Get (int* position);

	/*returns actual absolute servo positions in buffer*/

	

	int  GetLimit (int position);

	/*returns absolute servo limit of chosen joint*/

	

	int  Move(int* delta, int speed);

	/*drives servos relative to their actual positions with chosen speed*/

	

	

    private:

	

	ServoHandle handle[NUMBEROFSERVOS];

	/*array of handles for servos, valid after called Init()*/

	

	int  position[NUMBEROFSERVOS];

	/*buffer for servo-positions*/

	

	int  limit[NUMBEROFSERVOS];

	/*limiters for servo-angles (to protect the hardware!!!)*/

	

	bool initialized;

	/*latch to determine, if servos are initialised*/

	

	Servo();

	/*standard constructor for initialisations*/

	

	static Servo SingleInstance;	

	/*The Single Instance of this Class*/

	

};





#endif

