/* ----------------------------------------------------------------- */

/* 'InfraRed.h'										    */

/* Header for ZInfraRed.cc								    */

/* Supporting functions for IR-RemoteControl use			         */

/* 													    */

/* 	last modified 07/04/2003								    */

/* 	secondary power supply must be switched on for IR receiver	    */

/* 													    */

/* 	(C) Jochen Zimmermann								    */

/* ----------------------------------------------------------------- */



//avoid redefinition during static binding

#ifndef ZINFRARED

#define ZINFRARED



#include "ZHeaders.h"

/*

//needed headers, included via ZHeaders.h

#include "eyebot.h" 

#include "irtv.h"

#include "IRnokia_vcn620.h"

*/



#define SIZEOFINPUTBUFFER 20



class UserInput

{

    public:

	

	static UserInput* GetTheInstance();

	/*instance retriever*/

	

	int Init();

	/*initialises members and IR-receiver, necessary for IR*/

	

	int Read();

	/*non-blocking function that returns wether a key has been 

	pressed or not*/

	

	int Wait();

	/*blocking function to wait for any key*/

	

	int WaitTime(int time=-1);

	/*blocking function to wait for any key for at least specified 

	wait_time (wait_time=time*10ms), -1=infinite*/

	

	

	int Wait(int specified_key);

	/*blocking function to wait for a specified key*/

		

	int Flush();

	/*empties internal read-buffer*/

	

	

    private:

	

	int  AppendToBuffer(int value);

	/*internal buffer that handles readings from keys and IR, appends read key to 

	the buffer*/

	

	int	GetFromBuffer();

	/*returns last key in buffer*/

	

	bool WrapMultiReadings();

	/*extinguishes double readings in the buffer, according to chosen sensitivity*/

	

	

	int inputbuffer[SIZEOFINPUTBUFFER][2];

	/*buffer for read keys, also stores the time, when a key was read*/

	

	int bufferpos;

	/*pointer to actual buffer-position*/

	

	

	UserInput();

	/*standard constructor for initialisations*/

	

	static UserInput SingleInstance;

	/*The Single Instance of this Class*/

	

};



#endif

