/**
 * Hardware data for the Eyebot
 *
 * For a description of the data types see hdt.h
 *
 */

#ifndef EYEBOT_HARDWARE_DATA_H
#define EYEBOT_HARDWARE_DATA_H

#include "eyebot_hardware_types.h"
#include "cam.h"
#include "rs232.h"
#include "irtv.h"
#include "IRnokia.h"
#include "const.h"
#include "librobi/librobi.h"
#include "IRnokia.h"

/**
 * LOOK-UP DATA
 */

// PSD_FRONT LOOK-UP
short dist0[128] = { 60,  60,  60,  60,  60,  60,  60,  60,  60,  60,  60,  60,  60,  60,  60,
                     60,  60,  60,  60,  60,  60,  60,  60,  60,  60,  65,  69,  70,  73,  75,
                     76,  77,  79,  81,  84,  85,  87,  88,  89,  90,  93,  95,  96,  98, 100,
                    103, 105, 107, 109, 110, 112, 114, 116, 117, 119, 121, 126, 127, 129, 131,
                    134, 137, 140, 144, 146, 149, 151, 156, 159, 167, 170, 175, 179, 183, 188,
                    195, 200, 205, 210, 220, 225, 235, 240, 250, 265, 275, 285, 295, 310, 320,
                    340, 350, 370, 380, 400, 410, 440, 460, 490, 530, 600, 610, 630, 680, 750,
                    830, 900, 999, 999, 999, 999, 999, 999, 999, 999, 999, 999, 999, 999, 999,
                    999, 999, 999, 999, 999, 999, 999, 999};

// PSD_LEFT LOOK-UP
short dist1[128] = { 60,  60,  60,  60,  60,  60,  60,  60,  60,  60,  60,  60,  60,  60,  60,
                     60,  60,  60,  60,  60,  60,  60,  60,  60,  60,  65,  69,  70,  73,  75,
                     76,  77,  79,  81,  84,  85,  87,  88,  89,  90,  93,  95,  96,  98, 100,
                    103, 105, 107, 109, 110, 112, 114, 116, 117, 119, 121, 126, 127, 129, 131,
                    134, 137, 140, 144, 146, 149, 151, 156, 159, 167, 170, 175, 179, 183, 188,
                    195, 200, 205, 210, 220, 225, 235, 240, 250, 265, 275, 285, 295, 310, 320,
                    340, 350, 370, 380, 400, 410, 440, 460, 490, 530, 600, 610, 630, 680, 750,
                    830, 900, 999, 999, 999, 999, 999, 999, 999, 999, 999, 999, 999, 999, 999,
                    999, 999, 999, 999, 999, 999, 999, 999};

// PSD_RIGHT LOOK-UP
short dist2[128] = { 60,  60,  60,  60,  60,  60,  60,  60,  60,  60,  60,  60,  60,  60,  60,
                     60,  60,  60,  60,  60,  60,  60,  60,  60,  60,  65,  69,  70,  73,  75,
                     76,  77,  79,  81,  84,  85,  87,  88,  89,  90,  93,  95,  96,  98, 100,
                    103, 105, 107, 109, 110, 112, 114, 116, 117, 119, 121, 126, 127, 129, 131,
                    134, 137, 140, 144, 146, 149, 151, 156, 159, 167, 170, 175, 179, 183, 188,
                    195, 200, 205, 210, 220, 225, 235, 240, 250, 265, 275, 285, 295, 310, 320,
                    340, 350, 370, 380, 400, 410, 440, 460, 490, 530, 600, 610, 630, 680, 750,
                    830, 900, 999, 999, 999, 999, 999, 999, 999, 999, 999, 999, 999, 999, 999,
                    999, 999, 999, 999, 999, 999, 999, 999};

// MOTOR_LEFT LOOK-UP
BYTE motconvA[101]= { 0, 0, 0, 1, 1, 1, 1, 1, 2, 2, 2, 2, 3, 3, 3, 3, 4, 4, 4, 4,
                      5, 5, 5, 5, 6, 6, 6, 6, 7, 7, 7, 8, 8, 8, 8, 9, 9, 9, 10,10,
                      10,11,11,11,12,12,13,13,13,14,14,15,15,15,16,16,17,17,18,18,
                      19,19,20,20,21,21,22,23,23,24,25,25,26,27,27,28,29,30,31,32,
                      33,34,35,36,37,39,40,42,43,45,47,49,52,54,57,61,66,72,80,94,
                      100};

// MOTOR_RIGHT LOOK-UP
BYTE motconvB[101]= { 0, 0, 0, 1, 1, 1, 1, 1, 2, 2, 2, 2, 3, 3, 3, 3, 4, 4, 4, 4,
                      5, 5, 5, 5, 6, 6, 6, 6, 7, 7, 7, 8, 8, 8, 8, 9, 9, 9, 10,10,
                      10,11,11,11,12,12,13,13,13,14,14,15,15,15,16,16,17,17,18,18,
                      19,19,20,20,21,21,22,23,23,24,25,25,26,27,27,28,29,30,31,32,
                      33,34,35,36,37,39,40,42,43,45,47,49,52,54,57,61,66,72,80,94,
                      100};

/* EyeBot SUMMARY */
info_type roboinfo  = {0,VEHICLE,SER115200,RTSCTS,SERIAL1,0,0,AUTOBRIGHTNESS,BATTERY_ON,33,VERSION,NAME,ID};

/* waitstates = 0..13, Fast Termination = 14, External = 15 */
/* Version, ROM, RAM, LCD, IO, Parallel+Serial2/3 */
/* 16MHz - 20Mhz */
/* waitstate_type waitstates = {0,3,0,1,0,2}; */
/* 21MHz - 41Mhz */
waitstate_type waitstates = {0,3,1,2,1,2};

/**
 * DC MOTORS
 */

motor_type motorA = {2, 1, TIMER1, 8191, (void*)sim_porte, 2, 3, motconvA};
motor_type motorB = {2, 0, TIMER1, 8191, (void*)sim_porte, 1, 0, motconvB};

quad_type  encoderA = {0, 4, 5, MOTOR_RIGHT, 3240, 2.0};
quad_type  encoderB = {0, 3, 2, MOTOR_LEFT,  3240, 2.0};


/* SERVOs */
/* type, TPU-channel, Timer2, 20ms period, 0.7ms min, 1.7ms max */
/* here: servo 1 has TPU channel 2, and so on                   */
servo_type servo1  = {2,  2, TIMER2, 20000, 700, 1700};
servo_type servo2  = {2,  3, TIMER2, 20000, 700, 1700};
servo_type servo3  = {2,  4, TIMER2, 20000, 700, 1700};
servo_type servo4  = {2,  5, TIMER2, 20000, 700, 1700};
servo_type servo5  = {2,  6, TIMER2, 20000, 700, 1700};
servo_type servo6  = {2,  7, TIMER2, 20000, 700, 1700};
servo_type servo7  = {2,  8, TIMER2, 20000, 700, 1700};
servo_type servo8  = {2,  9, TIMER2, 20000, 700, 1700};
servo_type servo9  = {2, 10, TIMER2, 20000, 700, 1700};
servo_type servo10 = {2, 11, TIMER2, 20000, 700, 1700};
servo_type servo11 = {2, 12, TIMER2, 20000, 700, 1700};
servo_type servo12 = {2, 13, TIMER2, 20000, 700, 1700};

/* PSD-infrared */
psd_type psd0   = {0, 14, (BYTE*)IOBase, 0, AH, (BYTE*)IOBase, 0, AH, (short*)&dist0};
psd_type psd1   = {0, 14, (BYTE*)IOBase, 1, AH, (BYTE*)IOBase, 0, AH, (short*)&dist1};
psd_type psd2   = {0, 14, (BYTE*)IOBase, 2, AH, (BYTE*)IOBase, 0, AH, (short*)&dist2};
psd_type psd3   = {0, 14, (BYTE*)IOBase, 3, AH, (BYTE*)IOBase, 0, AH, (short*)&dist0};

/* compass */
compass_type compass = {0,6,(void*)IOBase, 5,(void*)IOBase, 6, (BYTE*)IOBase, 4};

/* IRTV */
//irtv_type irtv = {1, 12, TPU_HIGH_PRIO, REMOTE_ON, SPACE_CODE, 15,
//0x0000, 0x03FF, DEFAULT_MODE, 1, -1, RC_RED, RC_GREEN, RC_YELLOW,
//RC_BLUE};

irtv_type irtv = {0, 12, TPU_HIGH_PRIO};


#endif
