//## begin module%1.4%.codegen_version preserve=yes
//   Read the documentation to learn more about C++ code generator

//   versioning.
//## end module%1.4%.codegen_version

//## begin module%3D9AC98B0294.cm preserve=no
//	  %X% %Q% %Z% %W%
//## end module%3D9AC98B0294.cm

//## begin module%3D9AC98B0294.cp preserve=no
//## end module%3D9AC98B0294.cp

//## Module: Behavior%3D9AC98B0294; Pseudo Package specification
//## Source file: C:\Program Files\Rational\Rose\C++\source\Behavior.h

#ifndef Behavior_h
#define Behavior_h 1

//## begin module%3D9AC98B0294.additionalIncludes preserve=no
//## end module%3D9AC98B0294.additionalIncludes

//## begin module%3D9AC98B0294.includes preserve=yes
//## end module%3D9AC98B0294.includes

// SIR
#include "SIR.h"
// Drive
#include "Drive.h"
//## begin module%3D9AC98B0294.additionalDeclarations preserve=yes
class Commander;
//## end module%3D9AC98B0294.additionalDeclarations


//## begin Behavior%3D9AC98B0294.preface preserve=yes
//## end Behavior%3D9AC98B0294.preface

//## Class: Behavior%3D9AC98B0294
//	/**
//	Base class from which all behaviors are derived. This
//	provides them with the same base properties and makes
//	adaptations that are to effect all behaviors easier.
//	@author Jia L. Du
//	 */
//## Category: <Top Level>
//## Persistence: Transient
//## Cardinality/Multiplicity: n



class Behavior
{
  //## begin Behavior%3D9AC98B0294.initialDeclarations preserve=yes
  //## end Behavior%3D9AC98B0294.initialDeclarations

  public:
    //## Constructors (generated)
      Behavior();

    // Additional Public Declarations
      //## begin Behavior%3D9AC98B0294.public preserve=yes
      //	/**
      //	Used to set the commander for this behavior
      //	@param aCommander The commander for this behavior
			//	@see myCommander
      //	*/
      void setCommander(Commander& aCommander);
      
      //	/**
      //	The simulator does not allow the usage of RoBIOS functions
      //  in class constructors. Therefore we use public
      //  initialize methods for classes that need RoBIOS functions for
      //  their initializations.
      //	*/
      void initialize(void);
      //## end Behavior%3D9AC98B0294.public

  protected:
    // Data Members for Associations

      //## Association: <unnamed>%3D9ACA1C0118
      //## Role: Behavior::<drive>%3D9ACA1D0140
      //	/**
      //	Every Behavior gets access to the Drive to control robot
      //	movement
      //	*/
      //## begin Behavior::<drive>%3D9ACA1D0140.role preserve=no  public: Drive { -> RHN}
      Drive *drive;
      //## end Behavior::<drive>%3D9ACA1D0140.role

      //## Association: <unnamed>%3D9ACA2B0226
      //## Role: Behavior::<sIR>%3D9ACA2E01CC
      //	/**
      //	Every Behavior gets access to the high-level environment
      //	information provided by the SIR
      //	*/
      //## begin Behavior::<sIR>%3D9ACA2E01CC.role preserve=no  public: SIR { -> RHN}
      SIR* sir;
      //## end Behavior::<sIR>%3D9ACA2E01CC.role

    // Additional Protected Declarations
      //## begin Behavior%3D9AC98B0294.protected preserve=yes
      //	/**
      //	Every Behavior knows its own commander
      //	(e.g. to tell the commander that the behavior
      //	wants to cede control or wants to sleep for some time)
      //	*/
      Commander* myCommander;

      //	/**
      //	Every Behavior knows the size of the
      //	cluster area
      //	*/
  	  double clusterRadius;
	  
      //	/**
      //	This value is used to store the estimated cube density
      //	of the current cluster point
      //	 */
      double myClusterPointDensity;

      //## end Behavior%3D9AC98B0294.protected

  private:
    // Additional Private Declarations
      //## begin Behavior%3D9AC98B0294.private preserve=yes
      //## end Behavior%3D9AC98B0294.private

  private: //## implementation

    // Additional Implementation Declarations
      //## begin Behavior%3D9AC98B0294.implementation preserve=yes
      //## end Behavior%3D9AC98B0294.implementation

};

//## begin Behavior%3D9AC98B0294.postscript preserve=yes
//## end Behavior%3D9AC98B0294.postscript

// Class Behavior

//## begin module%3D9AC98B0294.epilog preserve=yes
//## end module%3D9AC98B0294.epilog


#endif
