/* ********************************* */
/* autobrightness.c                  */
/* Camera Autobrightness             */
/* Thomas Braunl, UWA, 2005          */
/* ********************************* */

#include "eyebot.h"
#include <stdlib.h>
#define DEBUG 1

void AutobrightSet (colimage img, float factor)
/* calculate autobrightness function, use diagonal */
{ int y;
  count = 0;  /* init */
  for (y=1;y<imagerows-1;y++)
    count += img[y][y][0] + img[y][y][1] + img[y][y][2];
  factor = 23040/count;
}


void AutobrightApply (colimage img, float factor)
/* apply autobrightness factor */
{ int x,y;
  count = 0;  /* init */
  for (x=1;x<imagecolumns-1;x++)
    for (y=1;y<imagerows-1;y++)
    { img[y][x][0] = img[y][x][0] * factor;
      img[y][x][1] = img[y][x][1] * factor;
      img[y][x][2] = img[y][x][2] * factor;
    }
}



#define X 40
#define Y 40
int main()
{ colimage c;
  int hue, pos, val;
  LCDPrintf("Teach Color\n");
  LCDMenu("TEA","","","");
  CAMInit(NORMAL);
  while ((KEYRead() != KEY1))
  { CAMGetColFrame(&c,0);
    LCDPutColorGraphic(&c);
    hue = RGBtoHue(c[Y][X][0], c[Y][X][1], c[Y][X][2]);
    LCDSetPos(1,0);
    LCDPrintf("R%3d G%3d B%3d\n", c[Y][X][0], c[Y][X][1], c[Y][X][2]);
    LCDPrintf("hue %3d\n", hue);
	if (DEBUG) fprintf(stderr, "hue %3d\n", hue);
    OSWait(100);
  }

  LCDClear();
  LCDPrintf("Detect Color\n");
  LCDMenu("","","","END");
  if (hue==255) LCDPrintf("Invalid Hue\n");
  else
    while (KEYRead() != KEY4)
    { CAMGetColFrame(&c,0);
      LCDPutColorGraphic(&c);
      ColSearch(c, hue, 10, &pos, &val);  /* search image */
      LCDSetPos(1,0);
      LCDPrintf("h%3d p%2d v%2d\n", hue, pos, val);
      LCDLine  (pos, 0, pos, 53, 2);  /* vertical line */
    }
  return 0;
}
