//## begin module%1.4%.codegen_version preserve=yes
//   Read the documentation to learn more about C++ code generator
//   versioning.
//## end module%1.4%.codegen_version

//## begin module%3D86D33A00C8.cm preserve=no
//	  %X% %Q% %Z% %W%
//## end module%3D86D33A00C8.cm

//## begin module%3D86D33A00C8.cp preserve=no
//## end module%3D86D33A00C8.cp

//## Module: UI%3D86D33A00C8; Pseudo Package specification
//## Source file: C:\Program Files\Rational\Rose\C++\source\UI.h

#ifndef UI_h
#define UI_h 1

//## begin module%3D86D33A00C8.additionalIncludes preserve=no
//## end module%3D86D33A00C8.additionalIncludes

//## begin module%3D86D33A00C8.includes preserve=yes
//## end module%3D86D33A00C8.includes

// Starter
#include "Starter.h"
// LCD
#include "LCD.h"
// Keyboard
#include "Keyboard.h"
// Thread
#include "Thread.h"
//## begin module%3D86D33A00C8.additionalDeclarations preserve=yes
//## end module%3D86D33A00C8.additionalDeclarations


//## begin UI%3D86D33A00C8.preface preserve=yes
//## end UI%3D86D33A00C8.preface

//## Class: UI%3D86D33A00C8
//	/**
//	This class implements the user interface. It allows the
//	user to start and stop the clustering using the
//	input buttons of the EyeBot controller.
//	@author Jia L. Du
//	 */
//## Category: <Top Level>
//## Persistence: Transient
//## Cardinality/Multiplicity: n



class UI : public Thread  //## Inherits: <unnamed>%3D86D5A8029E
{
  //## begin UI%3D86D33A00C8.initialDeclarations preserve=yes
  //## end UI%3D86D33A00C8.initialDeclarations

  public:
    //## Constructors (specified)
      //## Operation: UI%3D9EBE030096
      //	/**
      //	Constructor for UI. The parameters are passed to the
      //	Thread constructor
      //	@param name pointer to thread name
      //	@param stackSize size of thread stack
      //	@param priority thread priority (valid values are: MIN_
      //	PRI to MAX_PRI)
      //	@param id a unique thread id
      //	 */
      UI (char* name, int stackSize, int priority, int id);

    // Additional Public Declarations
      //## begin UI%3D86D33A00C8.public preserve=yes
      //	/**
      //	According to C++ convention, methods cannot be static and
      //	virtual at once. In the initial design run was declared as
      //	virtual which results in dynamic binding. That means the
      //	program determines at run-time which run method to use,
      //	the one of the Thread base class or the one of the inheritor.
      //	Because we have to use staticRun, we cannot use the virtual
      //	keyword anymore. Without the virtual keyword the compiler
      //	determines at compile-time which run method is used, always
      //	the run method of the Thread base class. To ensure that the
      //	inheritor indeed uses its own run method, it is necessary to
      //	overwrite the thread initialization method (spawn) as well.
      //	@see staticRun
      //	@return true if successful
      //	*/
      bool spawn ();

      //	/**
      //	The simulator does not allow the usage of RoBIOS functions
      //  in class constructors. Therefore we use public
      //  initialize methods for classes that need RoBIOS functions for
      //  their initializations.
      //	*/
      void initialize(void);
      //## end UI%3D86D33A00C8.public

  protected:

    // Additional Protected Declarations
      //## begin UI%3D86D33A00C8.protected preserve=yes
      void run(void); //protected or private??
      
      //	/**
      //	Static wrapper method for run. It does nothing but to call run.
      //	That is necessary because the RoBIOS multi-tasking functions expect
      //	a pointer to a C-function (not a pointer to a C++ method) containing
      //	the code to be executed. Fortunately, pointer-to-static-C++-methods
      //	are compatible with regular pointer-to-C-functions. But the problem
      //	is that static methods can only use other static methods and variables.
      //	The reasons is that a static method, which is shared by all instances,
      //	would not know which non-static method or variable to use if there were
      //	multiple instances of the same class. Thus, the static property would
      //	have to be applied to all used (sub-)methods and (sub-) variables,
      //	and propagate through the whole class structure. By using staticRun,
      //	we can keep using our non-static run. If static methods cannot call
      //	non-static ones, how can staticRun call run? As aforementioned the
      //	reason why static method cannot use non-static members is because it
      //	is not clear which non-static member to use if there are multiple
      //	instances of the same class. That means staticRun needs a pointer
      //	to the instance whose run method is to be called. This pointer is
      //	stored in a static member variable called me.
      //	@see me
      //	*/
      static void staticRun(void); //protected or private??
      //## end UI%3D86D33A00C8.protected

  private:
    // Additional Private Declarations
      //## begin UI%3D86D33A00C8.private preserve=yes
      //	/**
      //	Stores pointers to instances of UI
      //	@see staticRun
      //	*/
      static UI* mes[NUMBER_OF_ROBOTS];
      //## end UI%3D86D33A00C8.private

  private: //## implementation
    // Data Members for Class Attributes

      //## Attribute: state%3D901F660050
      //	/**
      //	Used by the class to keep track of its current state.
      //	Possible states are UI::READY, UI::RUNNING
      //	 */
      //## begin UI::state%3D901F660050.attr preserve=no  private: int {U} -1
      int state;
      //## end UI::state%3D901F660050.attr

      //## Attribute: READY%3D9AB2D2003C
      //	/**
      //	Used by the class to keep track of its own state
      //	*/
      //## begin UI::READY%3D9AB2D2003C.attr preserve=no  private: static int {UC} 0
      static const int READY;
      //## end UI::READY%3D9AB2D2003C.attr

      //## Attribute: RUNNING%3D9AB2F201A4
      //	/**
      //	Used by the class to keep track of its own state
      //	*/
      //## begin UI::RUNNING%3D9AB2F201A4.attr preserve=no  private: static int {UC} 1
      static const int RUNNING;
      //## end UI::RUNNING%3D9AB2F201A4.attr

    // Data Members for Associations

      //## Association: <unnamed>%3D86D4900226
      //## Role: UI::<keyboard>%3D86D49201A4
      //	/**
      //	The UI uses the Keyboard to receive user input
      //	*/
      //## begin UI::<keyboard>%3D86D49201A4.role preserve=no  public: Keyboard { -> RHN}
      Keyboard keyboard;
      //## end UI::<keyboard>%3D86D49201A4.role

      //## Association: <unnamed>%3D86D493015E
      //## Role: UI::<lCD>%3D86D49400AA
      //	/**
      //	The UI uses the LCD to display output for the user
      //	*/
      //## begin UI::<lcd>%3D86D49400AA.role preserve=no  public: LCD { -> RHN}
      LCD lcd;
      //## end UI::<lcd>%3D86D49400AA.role

      //## Association: <unnamed>%3D8FF19D00C8
      //## Role: UI::<starter>%3D8FF1A003DE
      //	/**
      //	The UI uses the Starter to control the clustering
      //	algorithm
      //	*/
      //## begin UI::<starter>%3D8FF1A003DE.role preserve=no  public: Starter { -> RHN}
      Starter starter;
      //## end UI::<starter>%3D8FF1A003DE.role

    // Additional Implementation Declarations
      //## begin UI%3D86D33A00C8.implementation preserve=yes
      //## end UI%3D86D33A00C8.implementation

};

//## begin UI%3D86D33A00C8.postscript preserve=yes
//## end UI%3D86D33A00C8.postscript

// Class UI 

//## begin module%3D86D33A00C8.epilog preserve=yes
//## end module%3D86D33A00C8.epilog


#endif
