//## begin module%1.4%.codegen_version preserve=yes
//   Read the documentation to learn more about C++ code generator
//   versioning.
//## end module%1.4%.codegen_version

//## begin module%3D883FDA01E0.cm preserve=no
//	  %X% %Q% %Z% %W%
//## end module%3D883FDA01E0.cm

//## begin module%3D883FDA01E0.cp preserve=no
//## end module%3D883FDA01E0.cp

//## Module: ImageFilter%3D883FDA01E0; Pseudo Package body
//## Source file: C:\Program Files\Rational\Rose\C++\source\ImageFilter.cpp

//## begin module%3D883FDA01E0.additionalIncludes preserve=no
//## end module%3D883FDA01E0.additionalIncludes

//## begin module%3D883FDA01E0.includes preserve=yes
//## end module%3D883FDA01E0.includes

// ImageFilter
#include "ImageFilter.h"
//## begin module%3D883FDA01E0.additionalDeclarations preserve=yes
//## end module%3D883FDA01E0.additionalDeclarations


// Class ImageFilter

ImageFilter::ImageFilter()
  //## begin ImageFilter::ImageFilter%3D883FDA01E0_const.hasinit preserve=no
  //## end ImageFilter::ImageFilter%3D883FDA01E0_const.hasinit
  //## begin ImageFilter::ImageFilter%3D883FDA01E0_const.initialization preserve=yes
  //## end ImageFilter::ImageFilter%3D883FDA01E0_const.initialization
{
  //## begin ImageFilter::ImageFilter%3D883FDA01E0_const.body preserve=yes
  LCDPrintf("ImageFilter constr.\n");
  LCDPrintf("done\n");
  //## end ImageFilter::ImageFilter%3D883FDA01E0_const.body
}




//## Other Operations (implementation)
void ImageFilter::sobelFilter (image& source, image& destination)
{
  //## begin ImageFilter::sobelFilter%3D9028C90190.body preserve=yes
	IPSobel(&source, &destination);
  //## end ImageFilter::sobelFilter%3D9028C90190.body
}

void ImageFilter::color2Grey (colimage& source, image& destination)
{
  //## begin ImageFilter::color2Grey%3D90290E033E.body preserve=yes
	IPColor2Grey(&source, &destination);
  //## end ImageFilter::color2Grey%3D90290E033E.body
}

void ImageFilter::calculateHue (colimage& source, int row, image& destination)
{
  //## begin ImageFilter::calculateHue%3D994BC002A8.body preserve=yes
	BYTE* in = (BYTE*)source;
	BYTE* out = (BYTE*)destination;
  for(int column=1; column<=imagecolumns-2; column++) //from 1 to 80
  {
   	out[row*imagecolumns + column] = RGBtoHue(in[(row*imagecolumns + column)*3],in[(row*imagecolumns + column)*3+1],in[(row*imagecolumns + column)*3+2]);
  }
  //## end ImageFilter::calculateHue%3D994BC002A8.body
}

// Additional Declarations
  //## begin ImageFilter%3D883FDA01E0.declarations preserve=yes
const BYTE ImageFilter::NO_HUE = 255;
#ifndef MIN
#define MIN(a,b) (a<b?a:b) //should not use macros??
#else
#error minimum function already defined
#endif
#ifndef MAX
#define MAX(a,b) (a>b?a:b) //should not use macros??
#else
#error maximum function already defined
#endif
	BYTE ImageFilter::RGBtoHue(BYTE r, BYTE g, BYTE b)
	{
  	int hue, delta, maximum, minimum;
  	maximum   = MAX(r, MAX(g,b));
  	minimum   = MIN(r, MIN(g,b));
  	delta = maximum - minimum;

/*from: http://www.cs.rit.edu/~ncs/color/
void RGBtoHSV( float r, float g, float b, float *h, float *s, float *v )
{
	float min, max, delta;

	min = MIN( r, g, b );
	max = MAX( r, g, b );
	*v = max;				// v

	delta = max - min;

	if( max != 0 )
		*s = delta / max;		// s
	else {
		// r = g = b = 0		// s = 0, v is undefined
		*s = 0;
		*h = -1;
		return;
	}

	if( r == max )
		*h = ( g - b ) / delta;		// between yellow & magenta
	else if( g == max )
		*h = 2 + ( b - r ) / delta;	// between cyan & yellow
	else
		*h = 4 + ( r - g ) / delta;	// between magenta & cyan

	*h *= 60;				// degrees
	if( *h < 0 )
		*h += 360;

}*/


  	if (3 * delta <= maximum) //is that correct??? only difference to above: NO_HUE if maximum <= 2*minimum instead of NO_HUE if maximum = 0
    	hue = NO_HUE;
  	else
  	{
    	if (r == maximum)
				hue =  42 + 42*(g-b) / delta; /* 1*42 */
    	else if  (g == maximum)
				hue = 126 + 42*(b-r) / delta; /* 3*42 */
    	else if (b == maximum)
        hue = 210 + 42*(r-g) / delta; /* 5*42 */
    	// now: hue is in range [0..252]
  	}

  	return BYTE(hue); //why not declare hue as BYTE?? Don't want to change original code
	}
#undef MIN //should not use macros??
#undef MAX //should not use macros??
  //## end ImageFilter%3D883FDA01E0.declarations

//## begin module%3D883FDA01E0.epilog preserve=yes
//## end module%3D883FDA01E0.epilog
