#ifndef GP_H
#define GP_H

#include "tree.h"

/* Data structure to hold fitness and position is the tree value to which the fitness corresponds to.
This is needed since qsort would be used later and this makes sure the fitness will then correspond to the
correct tree */
struct t_fitness {
	double fitness_value;
	int position;
};

//typedef struct t_fitness *Fitness;
typedef t_fitness *Fitness;

/* Data structure to hold all the trees in the population */
struct t_gp {
	Fitness fitness[MAXPOP];
	Tree t[MAXPOP]; // Current tree
	int n_nodes[MAXPOP]; // Not sure if it is needed... Just in case
};

typedef struct t_gp *Genetic;

Genetic initGeneticTrees (void);

void generatePopulation(Tree *t, int population, char *names, int gen_type);

void generateRandomTree(Tree t);

int CrossOver(Tree tree1, Tree tree2);

#endif
