/* *********************************** */
/* Testing servo-mounted camera        */
/* Thomas Braunl, Jan. 2005            */
/* *********************************** */
#include "eyebot.h"
ServoHandle servo1, servo2;

void checkpos(int pan, int tilt)
{ colimage c;

  SERVOSet(servo1, pan);
  SERVOSet(servo2, tilt);
  LCDSetPrintf(0,0,"PanTlt: %3d %3d\n", pan, tilt);
  CAMGetColFrame(&c,0);
  LCDPutColorGraphic(&c);
}


int main()
{ int pos;

  servo1 = SERVOInit(SERVO1);
  servo2 = SERVOInit(SERVO2);
  CAMInit(NORMAL);

  for (pos=128; pos<255; pos++) checkpos(pos, 128);
  for (pos=255; pos>0;   pos--) checkpos(pos, 128);
  for (pos=0;   pos<128; pos++) checkpos(pos, 128);

  for (pos=128; pos<255; pos++) checkpos(128, pos);
  for (pos=255; pos>0;   pos--) checkpos(128, pos);
  for (pos=0;   pos<128; pos++) checkpos(128, pos);

  return 0;
}

