#ifndef constgp
#define constgp

#define MAXPOP 500  // Number of Individuals
#define MAXEVO 500  // Number of Individuals
extern int POP;
extern int EVO;     // Number of Generations

#define true 1
#define false 0
#define TRUE 1
#define FALSE 0

/* used in the driving routines */
#define PI M_PI
#define THRESH_PSD 100
#define TURN_SPEED 0.5
#define TURN_ANGLE PI/12 /** 15 degree **/
#define DISTANCE 0.1 /** meters **/
#define FORWARD_SPEED 0.1 /** in 1 sec timeframe, the robot will cover 0.1 m;
			    that's 100 cm **/

/*used in the parser*/
#define MAX_BUFF_LEN	100
#define SYNTAX_ERROR 	69
#define TIMED_OUT	10000

/* used in the visual*/
#define distTableSize 56
#define NO 0
#define YES 1
#define NO_HUE -1
#define FOUND 1
#define NOTFOUND 0
#define LOW 20
#define HIGH 60

#define MIN(a,b) (a<b?a:b)
#define MAX(a,b) (a>b?a:b)

#define MAXHUE 255
#define MINHUE 0

#define WHITEPIX 255

#define PICHEIGHT 55
#define PICWIDTH 80

#define ILLEGALHUE 255
#define NOTDONE 0
#define DONE 1
#define FIRSTINIT 81

#define TWENTIETH 2
#define QUARTERSEC 2
#define HALFSEC 50

#define XTHRESDFLT 2
#define YTHRESDFLT 2
#define RANGEDFLT 8
#define ORANGE_HUE 62 	/** orange ball **/
#define RED_HUE 42	/** red ball **/
#define STEPSIZEDFLT 1
#define ILLEGALXY -1
#define FRAMESIZEAVE 5

#define FULL 1
#define NOT_FULL 0

#define term 0
#define func 1

typedef enum {
 /* value   0..8  */ psdfront, psdback, psdleft, psdright, objsize, objpos, low, high, msd,
 /* stat-a  9..12 */ turnleft, turnright, moveforward, movebackward,
 /* stat-l 13..15 */ PROGN2, IF_LESS, WHILE_LESS } symtype;

#define VAL_START  4  // do >not< use PSDs for now
#define VAL_NUM    4  // only use: objsize .. high
#define STA_START  9  
#define STA_ATOM_NUM  4
#define STA_NUM    7
#define LIST_START 13

#define VALUE 1000
#define STATEMENT 1001

#define PERCENTAGE 0.1		/* The percentage of trees that would be brought over to the next generation */
#define MINIMUM_SAFE_DIS 100 	/** safe distance in mm **/


#define SIM_TIMEOUT	30	/** maximum runtime in unit timesteps for any simulation **/
				/* NOTE: Defines number of times a moving function is called i.e. turn right,
				move forward, etc*/
#define TIMESTEP	1	/** a unit step in time */

#define FULLTREE	0
#define GROWTREE	1
#define RAMP_HALF	2
#define INITDEPTH	1
#define DEPTH		7
#define PROB_REPRO	0.1
#define PROB_REPLACE	0.4

#define INTERNAL	0	/** crossover point; crossover on functions **/
#define EXTERNAL	1	/** crossover point; crossover on terminals **/

#define INF		30.0	/** used in the fitness function. max dis is 30 **/
typedef int Sym_Type;

#endif
