#ifndef _EYEWIN_H_
#define _EYEWIN_H_

#include "wintypedefs.h"

/* VW ******************************************************************************************************/
extern VWInitPointer VWInit;
extern VWReleasePointer VWRelease;
extern VWSetSpeedPointer VWSetSpeed;
extern VWGetSpeedPointer VWGetSpeed;
extern VWSetPositionPointer VWSetPosition;
extern VWGetPositionPointer VWGetPosition;
extern VWStartControlPointer VWStartControl;
extern VWStopControlPointer VWStopControl;
extern VWDriveStraightPointer VWDriveStraight;
extern VWDriveTurnPointer VWDriveTurn;
extern VWDriveCurvePointer VWDriveCurve;
extern VWDriveRemainPointer VWDriveRemain;
extern VWDriveDonePointer VWDriveDone;
extern VWDriveWaitPointer VWDriveWait;
extern VWStalledPointer VWStalled;

/* PSD ***************************************************************************************************/

extern PSDInitPointer PSDInit;
extern PSDReleasePointer PSDRelease;
extern PSDStartPointer PSDStart;
extern PSDStopPointer PSDStop;
extern PSDCheckPointer PSDCheck;
extern PSDGetPointer PSDGet;
extern PSDGetRawPointer PSDGetRaw;

/* LCD ***************************************************************************************************/

extern LCDPrintfPointer LCDPrintf;
extern LCDSetPrintfPointer LCDSetPrintf;
extern LCDClearPointer LCDClear;
extern LCDPutCharPointer LCDPutChar;
extern LCDSetCharPointer LCDSetChar;
extern LCDPutStringPointer LCDPutString;
extern LCDSetStringPointer LCDSetString;
extern LCDModePointer LCDMode;
extern LCDGetPosPointer LCDGetPos;
extern LCDSetPosPointer LCDSetPos;
extern LCDPutColorGraphicPointer LCDPutColorGraphic;
extern LCDPutGraphicPointer LCDPutGraphic;
extern LCDPutImagePointer LCDPutImage;
extern LCDMenuPointer LCDMenu;
extern LCDMenuIPointer LCDMenuI;
extern LCDSetPixelPointer LCDSetPixel;
extern LCDInvertPixelPointer LCDInvertPixel;
extern LCDGetPixelPointer LCDGetPixel;
extern LCDLinePointer LCDLine;
extern LCDAreaPointer LCDArea;

int LCDPutFloat (float f);
int LCDPutFloatS (float f, int minsp, int decimals);
int LCDPutHex (int val);
int LCDPutHex1 (int val);
int LCDPutInt (int val);
int LCDPutIntS (int val, int spaces);

/* KEY ***************************************************************************************************/

extern KEYGetBufferPointer KEYGetBuffer;
extern KEYGetPointer KEYGet;
extern KEYReadPointer KEYRead;
extern KEYWaitPointer KEYWait;

/* OS/Multi-Threading *************************************************************************************/

extern OSMTInitPointer OSMTInit;
extern OSMTStatusPointer OSMTStatus;
extern OSSpawnPointer OSSpawn;
extern OSReadyPointer OSReady;
extern OSSuspendPointer OSSuspend;
extern OSReschedulePointer OSReschedule;
extern OSYieldPointer OSYield;
extern OSRunPointer OSRun;
extern OSGetUIDPointer OSGetUID;
extern OSKillPointer OSKill;
extern OSExitPointer OSExit;
extern OSPanicPointer OSPanic;
extern OSSleepPointer OSSleep;
extern OSForbidPointer OSForbid;
extern OSPermitPointer OSPermit;
extern OSSemInitPointer OSSemInit;
extern OSSemPPointer OSSemP;
extern OSSemVPointer OSSemV;
extern OSSetTimePointer OSSetTime;
extern OSGetTimePointer OSGetTime;
extern OSShowTimePointer OSShowTime;
extern OSGetCountPointer OSGetCount;
extern OSWaitPointer OSWait;
extern OSAttachTimerPointer OSAttachTimer;
extern OSDetachTimerPointer OSDetachTimer;
extern OSErrorPointer OSError;
extern OSMachineTypePointer OSMachineType;
extern OSMachineIDPointer OSMachineID;
extern OSMachineNamePointer OSMachineName;
extern OSMachineSpeedPointer OSMachineSpeed;
extern OSVersionPointer OSVersion;

/* RADIO ***************************************************************************************************/

extern RADIOInitPointer RADIOInit;
extern RADIOTermPointer RADIOTerm;
extern RADIOCheckPointer RADIOCheck;
extern RADIORecvPointer RADIORecv;
extern RADIOSendPointer RADIOSend;
extern RADIOSetIoct1Pointer RADIOSetIoct1;
extern RADIOGetIoct1Pointer RADIOGetIoct1;
extern RADIOGetStatusPointer RADIOGetStatus;

/* CAM ***************************************************************************************************/

extern CAMInitPointer CAMInit;
extern CAMReleasePointer CAMRelease;
extern CAMGetFramePointer CAMGetFrame;
extern CAMGetColFramePointer CAMGetColFrame;
extern CAMSetPointer CAMSet;
extern CAMGetPointer CAMGet;
extern CAMModePointer CAMMode;

/* IP ***************************************************************************************************/

extern IPLaplacePointer IPLaplace;
extern IPSobelPointer IPSobel;
extern IPDitherPointer IPDither;
extern IPDifferPointer IPDiffer;
extern IPColor2GreyPointer IPColor2Grey;

/* RS232 ***************************************************************************************************/

extern OSCheckInRS232Pointer OSCheckInRS232;
extern OSCheckOutRS232Pointer OSCheckOutRS232;
extern OSFlushInRS232Pointer OSFlushInRS232;
extern OSFlushOutRS232Pointer OSFlushOutRS232;
extern OSInitRS232Pointer OSInitRS232;
extern OSRecvRS232Pointer OSRecvRS232;
extern OSSendCharRS232Pointer OSSendCharRS232;
extern OSSendRS232Pointer OSSendRS232;

/**********************************************************************************************************/

extern OSEnablePointer OSEnable;
extern OSDisablePointer OSDisable;
extern OSGetVarPointer OSGetVar;
extern OSPutVarPointer OSPutVar;
extern OSDownloadPointer OSDownload;
extern AUPlaySamplePointer AUPlaySample;
extern AUCheckSamplePointer AUCheckSample;
extern AURecordSamplePointer AURecordSample;
extern AUCheckRecordPointer AUCheckRecord;
extern AUTonePointer AUTone;
extern AUBeepPointer AUBeep;
extern AUCaptureMicPointer AUCaptureMic;
extern AUCheckTonePointer AUCheckTone;
extern SERVOInitPointer SERVOInit;
extern SERVOReleasePointer SERVORelease;
extern SERVOSetPointer SERVOSet;
extern MOTORInitPointer MOTORInit;
extern MOTORReleasePointer MOTORRelease;
extern MOTORDrivePointer MOTORDrive;
extern QUADInitPointer QUADInit;
extern QUADReleasePointer QUADRelease;
extern QUADResetPointer QUADReset;
extern QUADReadPointer QUADRead;
extern QUADGetMotorPointer QUADGetMotor;
extern QUADODOReadPointer QUADODORead;
extern QUADODOResetPointer QUADODOReset;
extern BUMPInitPointer BUMPInit;
extern BUMPReleasePointer BUMPRelease;
extern BUMPCheckPointer BUMPCheck;
extern IRInitPointer IRInit;
extern IRReleasePointer IRRelease;
extern IRReadPointer IRRead;
extern OSReadInLatchPointer OSReadInLatch;
extern OSWriteOutLatchPointer OSWriteOutLatch;
extern OSReadOutLatchPointer OSReadOutLatch;
extern OSReadParDataPointer OSReadParData;
extern OSWriteParDataPointer OSWriteParData;
extern OSReadParSRPointer OSReadParSR;
extern OSWriteParCTRLPointer OSWriteParCTRL;
extern OSReadParCTRLPointer OSReadParCTRL;
extern OSGetADPointer OSGetAD;
extern OSOffADPointer OSOffAD;
extern COMPASSCalibratePointer COMPASSCalibrate;
extern COMPASSCheckPointer COMPASSCheck;
extern COMPASSGetPointer COMPASSGet;
extern COMPASSInitPointer COMPASSInit;
extern COMPASSReleasePointer COMPASSRelease;
extern COMPASSStartPointer COMPASSStart;
extern COMPASSStopPointer COMPASSStop;
extern SIMGetActualPosPointer SIMGetActualPos;
extern SIMGetActualPhiPointer SIMGetActualPhi;
extern SIMGetActualBallPosPointer SIMGetActualBallPos;
extern SIMSetBallPosPointer SIMSetBallPos;
extern SIMExitPointer SIMExit;
extern SIM_CAMSetPanTiltAnglePointer SIM_CAMSetPanTiltAngle;
extern SIM_SetKickerPointer SIM_SetKicker;

#endif

