/*
| -----------------------------------------------------------------------------
| Filename: hdttest.c
|
| Author:       Thomas Braunl   (braunl@ee.uwa.edu.au)
|               Klaus Schmitt   (kschmitt@informatik.uni-kl.de)
| Description: 
| -------
| STANDARD HDT data for EyeBot MK4, UWA Aug. 2000, 2005
| -----------------------------------------------------------------------------
*/

#define VERSION 1.1      /* User specific version nr. for information */
#define NAME "Eye-MK5"   /* controller name max. 7 chars, inform. only */
#define ID   1           /* Unique platform id (int), just for inform. */

#include "hdt.h"
#include "hdt_sem.h"
#include "IRnokia.h"
#include "irtv.h"

/* The HDT structure */
/*-------------------*/
int     magic = 123456789;
extern HDT_entry_type HDT[];
HDT_entry_type  *hdtbase = &HDT[0];

#include "types.h"
#include "const.h"
#include "rs232.h"
#include "cam.h"
#include "librobi/librobi.h"

/* infraread remote control on Servo S12 */
/* the final 1 is to state that it is used for ROBIOS */
irtv_type irtv =     {1, 13, TPU_HIGH_PRIO,
                      REMOTE_ON, SPACE_CODE, 15, 0x0000, 0x03FF, DEFAULT_MODE,
	                  1, -1, RC_RED, RC_GREEN, RC_YELLOW, RC_BLUE};

remote_type remote = {1, ID, REMOTE_OFF, SERIAL2, SER115200, IMAGE_REDUCED, RADIO_BLUETOOTH};

short dist0[128] = { 60,  60,  60,  60,  60,  60,  60,  60,  60,  60,  60,  60,  60,  60,  60,
                     60,  60,  60,  60,  60,  60,  60,  60,  60,  60,  65,  69,  70,  73,  75,
                     76,  77,  79,  81,  84,  85,  87,  88,  89,  90,  93,  95,  96,  98, 100,
                    103, 105, 107, 109, 110, 112, 114, 116, 117, 119, 121, 126, 127, 129, 131,
                    134, 137, 140, 144, 146, 149, 151, 156, 159, 167, 170, 175, 179, 183, 188,
                    195, 200, 205, 210, 220, 225, 235, 240, 250, 265, 275, 285, 295, 310, 320,
                    340, 350, 370, 380, 400, 410, 440, 460, 490, 530, 600, 610, 630, 680, 750,
                    830, 900, 999, 999, 999, 999, 999, 999, 999, 999, 999, 999, 999, 999, 999,
                    999, 999, 999, 999, 999, 999, 999, 999};

BYTE motconv0[101]= { 0, 1, 2, 3, 4, 5, 6, 7, 8, 9,10,11,12,13,14,15,16,17,18,19,
                     20,21,22,23,24,25,26,27,28,29,30,31,32,33,34,35,36,37,38,39,
                     40,41,42,43,44,45,46,47,48,49,50,51,52,53,54,55,56,57,58,59,
                     60,61,62,63,64,65,66,67,68,69,70,71,72,73,74,75,76,77,78,79,
                     80,81,82,83,84,85,86,87,88,89,90,91,92,93,94,95,96,97,98,99,
                     100};

/* DC motors */
/* Motor A = left, Motor B = right */
motor_type motorA = {2, 0, TIMER1, 8191, (void*)sim_porte, 0, 0, (BYTE*)0};
motor_type motorB = {2, 1, TIMER1, 8191, (void*)sim_porte, 1, 1, (BYTE*)0};
/* KLAUS: please check !! */

quad_type  encoderA = {0, 2, 3, MOTOR_LEFT,  3240, 2.0};
quad_type  encoderB = {0, 5, 4, MOTOR_RIGHT, 3240, 2.0};
vw_type drive = {0, DIFFERENTIAL_DRIVE, {QUAD_LEFT, QUAD_RIGHT, 0.085}};


/* SERVOs */
/* type, TPU-channel, Timer2, 20ms period, 0.7ms min, 1.7ms max */
/* here: servo 0 has TPU channel 0, and so on                   */
servo_type servo0  = {2,  0, TIMER2, 20000, 700, 1700};
servo_type servo1  = {2,  1, TIMER2, 20000, 700, 1700};
servo_type servo2  = {2,  2, TIMER2, 20000, 700, 1700};
servo_type servo3  = {2,  3, TIMER2, 20000, 700, 1700};
servo_type servo4  = {2,  4, TIMER2, 20000, 700, 1700};
servo_type servo5  = {2,  5, TIMER2, 20000, 700, 1700};
servo_type servo6  = {2,  6, TIMER2, 20000, 700, 1700};
servo_type servo7  = {2,  7, TIMER2, 20000, 700, 1700};
servo_type servo8  = {2,  8, TIMER2, 20000, 700, 1700};
servo_type servo9  = {2,  9, TIMER2, 20000, 700, 1700};
servo_type servo10 = {2, 10, TIMER2, 20000, 700, 1700};
servo_type servo11 = {2, 11, TIMER2, 20000, 700, 1700};
servo_type servo12 = {2, 12, TIMER2, 20000, 700, 1700};
servo_type servo13 = {2, 13, TIMER2, 20000, 700, 1700};

/* COMPASS */
compass_type compass = {0,13,(void*)IOBase, 2,(void*)IOBase, 4, (BYTE*)IOBase, 0};

/* PSD-infrared */
psd_type   psd0   = {0, 14, (BYTE*)IOBase, 0, AH, (BYTE*)IOBase, 0, AH, (short*)&dist0};
psd_type   psd1   = {0, 14, (BYTE*)IOBase, 1, AH, (BYTE*)IOBase, 0, AH, (short*)&dist0};
psd_type   psd2   = {0, 14, (BYTE*)IOBase, 2, AH, (BYTE*)IOBase, 0, AH, (short*)&dist0};
psd_type   psd3   = {0, 14, (BYTE*)IOBase, 3, AH, (BYTE*)IOBase, 0, AH, (short*)&dist0};
psd_type   psd4   = {0, 14, (BYTE*)IOBase, 4, AH, (BYTE*)IOBase, 0, AH, (short*)&dist0};
psd_type   psd5   = {0, 14, (BYTE*)IOBase, 5, AH, (BYTE*)IOBase, 0, AH, (short*)&dist0};


/* EyeBot SUMMARY */
info_type roboinfo  = {0,MK5,SER115200,RTSCTS,SERIAL1,0,0,AUTOBRIGHTNESS,BATTERY_ON,33,VERSION,NAME,ID};

/* waitstates = 0..13, Fast Termination = 14, External = 15 */
/* Version, ROM, RAM, LCD, IO, Parallel+Serial2/3 */
/* 16MHz - 20Mhz */
/* waitstate_type waitstates = {0,3,0,1,0,2}; */
/* 21MHz - 41Mhz */
waitstate_type waitstates = {0,3,1,2,1,2};

/* include startup sound and image */
#include "startup.h"

/* this is a test HDT structure which contains ALL EyeBot hardware devices */
HDT_entry_type HDT[] =
{                   
/*  {MOTOR,MOTOR_LEFT,"MotA-L",  (void *)&motorA},
    {MOTOR,MOTOR_RIGHT,"MotB-R",(void *)&motorB},
    {QUAD, QUAD_LEFT,"LEFT",   (void *)&encoderA},
    {QUAD, QUAD_RIGHT,"RIGHT", (void *)&encoderB},
    {VW,VW,"Drive",(void *)&drive},
*/                    

    {SERVO,SERVO0, "SERV00",(void *)&servo0},
    {SERVO,SERVO1, "SERV01",(void *)&servo1},
    {SERVO,SERVO2, "SERV02",(void *)&servo2},
    {SERVO,SERVO3, "SERV03",(void *)&servo3},
    {SERVO,SERVO4, "SERV04",(void *)&servo4},
    {SERVO,SERVO5, "SERV05",(void *)&servo5},
    {SERVO,SERVO6, "SERV06",(void *)&servo6},
    {SERVO,SERVO7, "SERV07",(void *)&servo7},
    {SERVO,SERVO8, "SERV08",(void *)&servo8},
    {SERVO,SERVO9, "SERV09",(void *)&servo9},
    {SERVO,SERVO10,"SERV10",(void *)&servo10},
    {SERVO,SERVO11,"SERV11",(void *)&servo11},
    {SERVO,SERVO12,"SERV12",(void *)&servo12},
    {SERVO,SERVO13,"SERV13",(void *)&servo13},
                  
    {PSD,PSD_FRONT,    "P0-F",  (void *)&psd0},
    {PSD,PSD_LEFT,     "P1-L",  (void *)&psd1},
    {PSD,PSD_RIGHT,    "P2-R",  (void *)&psd2},
    {PSD,PSD_LEFTDIAG, "P3-LD", (void *)&psd3},
    {PSD,PSD_RIGHTDIAG,"P4-RD", (void *)&psd4},
    {PSD,PSD_BACK,     "P5-BK", (void *)&psd5},
                    
    {WAIT,WAIT,"WAIT",(void *)&waitstates},
    {INFO,INFO,"INFO",(void *)&roboinfo},
                    
    {IRTV,IRTV,"IRTV",(void *)&irtv},
    {REMOTE,REMOTE,"BlueT",(void *)&remote},
	{STARTMELODY,STARTMELODY,"Melody",(void *)startmelody},
    {STARTIMAGE,STARTIMAGE,"Image",(void *)&startimage},
                    
    {END_OF_HDT,UNKNOWN_SEMANTICS,"END",(void *)0}
};

