/*
*  qsmregs.s - define addresses of registers in Queued Serial Module
*  adjust the value of qmcr to reflect setting of modmap bit in sim mcr
*/

qmcr    =     0xfffffc00       | use full 32-bit address for sign extended addresses
qtest   =     qmcr+2          | qsm test register
qilr    =     qmcr+4          | qsm interrupt level register
qivr    =     qmcr+5          | qsm interrupt vector register
sccr0   =     qmcr+8          | sci control register 0
sccr1   =     qmcr+0xa          | sci control register 1
scsr    =     qmcr+0xc         | sci status register
scdr    =     qmcr+0xe         | sci data register
portqs	=     qmcr+0x14
qpdr    =     qmcr+0x15        | qsm port data register
qpar    =     qmcr+0x16        | qsm pin assignment register
qddr    =     qmcr+0x17        | qsm data direction register
spcr0   =     qmcr+0x18        | qspi control register 0
spcr1   =     qmcr+0x1a        | qspi control register 1
spcr2   =     qmcr+0x1c        | qspi control register 2
spcr3   =     qmcr+0x1e        | qspi control register 3
spsr    =     qmcr+0x1f        | qspi status register
qrxd    =     qmcr+0x100       | qspi receive data buffer start
qtxd    =     qmcr+0x120       | qspi transmit data buffer start
qcmd    =     qmcr+0x140       | qspi command buffer start

