@echo off
REM gcc68 cross-compiler script
REM Thomas Braunl, 2005

REM echo mc dir is: %mc%

REM options for Compile, Link, Assemble
set Copt=-specs=%gcc%\lib\3.3.1\specs -m68332 -I%mc%\include -I%gcc%\include -I%gcc%\lib\3.3.1\include -I%gcc%\include\c++\3.3.1 -I%gcc%\include\c++\3.3.1\m68k-eyebot-elf -Wall
set Lopt=-L%mc%\lib -L%gcc%\lib\3.3.1 -L%gcc%\lib -T%gcc%\ldscripts\m68kelf.x
set Aopt=-Wa,-I%mc%\include
set opt=%Copt% %Lopt% %Aopt%

REM determine whether object-copy is necessary (no linking for -c, -S, -E, -M)
set link=1
for %%a in (%*) do if %%a==-c set link=0
for %%a in (%*) do if %%a==-S set link=0
for %%a in (%*) do if %%a==-E set link=0
for %%a in (%*) do if %%a==-M set link=0

if %link% EQU 1 goto compilewithlink

:compile
m68k-eyebot-elf-gcc %opt% %*
goto end

:compilewithlink
REM overwrite output spec with "a.out.elf"
m68k-eyebot-elf-gcc  %opt% %* -lstdc++ -o a.out.elf
if %errorlevel% GTR 0 goto end

:outputname
REM determine output name (default "a.out")
set out=a.out
:objrepeat
if "%1"=="" goto objcopy
if "%2"=="" goto objcopy
if %1==-o set out=%2
shift /1
goto objrepeat


:objcopy
m68k-eyebot-elf-objcopy -O srec --gap-fill=0 a.out.elf %out%
del a.out.elf
if %errorlevel% GTR 0 goto end

:compress
REM srec2bin -cb %~n2.hex %~n2.hx >NUL
REM if %errorlevel% GTR 0 goto end

:end
@echo on
