/*
	Remote control codes for "SP-URC-81", Mode "TV1 170"
	Michael Kasper, AndroTec GmbH, 2005
*/

#ifndef IR_U170
#define IR_U170


#define RC_STANDBY		0x300C
#define RC_MUTE			0x300D
#define RC_CHPLUS		0x3020
#define RC_CHMINUS		0x3021
#define RC_VOLPLUS		0x3010
#define RC_VOLMINUS		0x3011
#define RC_INFO			0x300F
#define RC_TVVCR		0x3038		/* (same as RC_AB) 	  */

#define RC_0      		0x3000
#define RC_1      		0x3001
#define RC_2      		0x3002
#define RC_3      		0x3003
#define RC_4      		0x3004
#define RC_5      		0x3005
#define RC_6      		0x3006
#define RC_7      		0x3007
#define RC_8      		0x3008
#define RC_9      		0x3009
#define RC_ENTER  		0x300A
#define RC_AB	  		0x3038		/* (same as RC_TVVCR) */

#define RC_PLAY			0x3032
#define RC_STOP			0x3036
#define RC_PAUSE		0x3024
#define RC_FF			0x3034
#define RC_RW			0x3037
#define RC_RECORD		0x302E

#define RC_TV			0x303F
#define RC_TEXT			0x303C
#define RC_SMALL		0x3029

#define RC_SUP			0x3012
#define RC_SDOWN		0x3013
#define RC_SLEFT		0x3015
#define RC_SRIGHT		0x3014
#define RC_OK			0x3023

#define RC_MENU			0x300E
#define RC_EXIT			0x300B


/* Definitions for compatibility with older Remote Controls */

#define RC_UP	  		RC_CHPLUS
#define RC_DOWN  		RC_CHMINUS
#define RC_LEFT  		RC_VOLMINUS
#define RC_RIGHT  		RC_VOLPLUS

#define RC_RED			RC_RW
#define RC_GREEN		RC_STOP
#define RC_YELLOW		RC_PLAY
#define RC_BLUE			RC_FF

#define RC_PLUS			RC_SUP
#define RC_MINUS		RC_SDOWN

#define RC_CLEAR		RC_TVVCR
#define RC_TIMER		RC_TV
#define RC_CLOCK		RC_TEXT
#define RC_SETUP		RC_SMALL


#endif
