#ifndef  CONST_H
#define  CONST_H

#define sim_porte       0xfffa13
#define sim_portf       0xfffa1b

/* global memory layout 							*/
/* ATTENTION: const.i contains the same constants for assembler usage !!!!!! 	*/

#define MemoryStart             0x00000000              /* should be $0 normally */

#define MinRomSize              0x00020000              /* 128kB */

/* ---------------------------- */

#define HDTSize                 0x00004000              /* 16kB */

#define UserStart               MinRomSize 

/* Base Addresses */

#define RomBase                 0x00c00000              /* were the rom is mapped to */
#define TpuBase                 0x00a00000
/* #define HDTBase                 (RomBase+MinRomSize-HDTSize) */

#define CS2                     0x00e00000
#define CS4                     0x00e00800
#define CS5                     0x00e01000
#define CS8                     0x00e01800      
#define CS9                     0x00e02000
#define CS10                    0x00e02800

/* Eyebot Platform */

#define LcdBase                 CS2
#define OutBase                 CS4
#define InBase                  CS5
#define FIFOBase                CS5
#define ParBase                 CS8     
#define Ser1Base                CS9
#define Ser2Base                CS10

#define CamBase                 CS8     

/* Eyebot Vehicle */

#define IOBase                  CS4


/* bits of the system status byte */

#define TASKING  0       /* multitasking on/off */

/* system const save locations */

#define eofram	(240*4)
#define heapadr	(241*4)
#define mallocaddr (242*4)
#define freeaddr (243*4)
/* 244-255 may be used for new constants */


#define FLASH_MAGIC 0x11071971

#define MAX_IRQ 16

#define HALF_FIFO_LENGTH 2048

#endif
